
#ifndef HOSOKIKIKOU

#define HOSOKIKIKOU

#include "mbed.h"
#include "ikarashiMDC.h"

class HOSOKIkikou
{
public:

    HOSOKIkikou(ikarashiMDC *ik1, ikarashiMDC *ik2, ikarashiMDC *ik3, ikarashiMDC *ik4, uint8_t *b1, uint8_t *b2, uint8_t *b3, uint8_t *b4, int *env1, int *env2);
    
//    Serial(USBTX,USBRX,115200);
    
    void init(ikarashiMDC *ik1, ikarashiMDC *ik2, ikarashiMDC *ik3, ikarashiMDC *ik4, uint8_t *b1, uint8_t *b2, uint8_t *b3, uint8_t *b4, int *env1, int *env2);
    
    void runAll(float speedIRight, float speedILeft, float speedLoad, float speedLift);
    
    void runInjection(float speedRight, float speedLeft);
    
    void runLoad(float speed);
    
    void runLift(float speed);
    
    void stopAll();
    
    void checkAllMotorSpeed(float* data_buff);

private:
    
    Serial pc;
    int buff[2];
    uint8_t *button[4];
    int *encoder[3];
    float mspeed[4];
    bool injecterFlag;
    ikarashiMDC *ik[4];
    
};

#endif