#include "FEP.h"

FEP::FEP(PinName tx, PinName rx, uint8_t addr, int baud):serial(tx,rx)
{
    FEP::serial.baud(baud);
    FEP::_address = addr;
}
FEP::~FEP()
{

}

int FEP::rxHandler(char *data)
{
    int i,n;
    char buf[FEP_LINE_LEN];
    for(i=0,n=0; i <= FEP_LINE_LEN; i++) {
        while(FEP::serial.readable() == 0) {
            if(n > FEP_TIMEOUT_COUNT) return FEP_NO_RESPONSE;
            n++;
        }
        n=0;
        buf[i] = FEP::serial.getc();
        if(i >= 1 && (buf[i-1] == '\r' && buf[i] =='\n')) {
            for(n=0; n <= i; n++) {
                data[n] = buf[n];
            }
            return 0;
        }
    }
    return 1;
}

uint8_t FEP::getResponse()
{
    char buf[FEP_LINE_LEN];
    memset(buf, 0, sizeof(buf));
    if(FEP::rxHandler(buf) == FEP_NO_RESPONSE) {
        return FEP_NO_RESPONSE;
    }
    if (strlen(buf) > 4) {
        /* the packet in buffer is not response, continue to wait */
        return FEP::getResponse();
    }

    if (strcmp(buf, "P1\r\n") == 0) {
        return FEP::getResponse();
    } else {
        if (strcmp(buf, "P0\r\n") == 0) {
            return FEP_P0;
        } else if (strcmp(buf, "N0\r\n") == 0) {
            return FEP_N0;
        } else if (strcmp(buf, "N1\r\n") == 0) {
            return FEP_N1;
        } else if (strcmp(buf, "N2\r\n") == 0) {
            return FEP_N2;
        } else if (strcmp(buf, "N3\r\n") == 0) {
            return FEP_N3;
        } else {
            return FEP::getResponse();
        }
    }
}

uint8_t FEP::puts(char *data, uint8_t len)
{
    uint8_t response;

    FEP::serial.printf("@TXT%03uG",FEP::_address);
    for(int i = 0; i<len; i++) {
        FEP::serial.printf("%02x",data[i]);
    }
    FEP::serial.printf("H\r\n");
    response = FEP::getResponse();
    return response;
}

uint8_t FEP::putbin(char *ary, size_t len)
{
    uint8_t response, j;

    FEP::serial.printf("@TBN%03d%03d", FEP::_address, len);
    for (j = 0; j < len; j++) {
        FEP::serial.putc(ary[j]);
    }
    FEP::serial.putc('\r');
    FEP::serial.putc('\n');

    response = FEP::getResponse();
    response = FEP::getResponse();
    return response;
}

void FEP::hex2dec(char *data,char *str,uint8_t len)
{
    char *endptr;
    char buf[2];
    for(int i = 0; i < len*2; i+=2) {
        buf[0] = data[1+i];
        buf[1] = data[1+i+1];
        str[i/2] = (char)strtol(buf, &endptr, 16);
    }
}

int FEP::ctoi(char c)
{
    if('0' <= c && c <= '9') return (c-'0');
    else return -1;
}

uint8_t FEP::gets(char *data, uint8_t len)
{
    char buf[FEP_LINE_LEN], sub[FEP_LINE_LEN];
    uint8_t temp;
    uint16_t i;
    uint8_t data_mode;
    size_t data_len;
    memset(buf, 0, sizeof(buf));
    temp = FEP::rxHandler(buf);
    if(temp == FEP_NO_RESPONSE) {
        return FEP_NO_RESPONSE;
    } else if(temp == 1) {
        return FEP_DT_ERR;
    }
    if (strlen(buf) >= 3) {
        /* get command part */
        strncpy(sub, buf, 3);
        sub[3] = '\0';
        if (!strcmp(sub, "RXT")) {
            /* Subtract string from a part before the intensity  */
            strncpy(sub, buf, strlen(buf) - 3 - 2);
            sub[strlen(buf) - 3 - 2 + 1] = '\0';

            /* Get transmitter's address */
            temp = 0;
            temp += FEP::ctoi(sub[3])*100;
            temp += FEP::ctoi(sub[4])*10;
            temp += FEP::ctoi(sub[5])*1;
            FEP::_transmitterAddr = temp;
            /* Store message to str */
            data_len = strlen(buf) - 6 - 3 - 2;
            if (data_len > len) {
                /* received data is too long! */
                return FEP_DT_ERR;
            }
            strncpy(data, buf + 6, data_len);

            /* Get intensity part of string */
            strncpy(sub, buf + strlen(buf) - 3 - 2, 3);
            sub[3] = '\0';
            data_mode = FEP_DT_STR;
        } else if (!strcmp(sub, "RBN")) {
            /* addr and length part */
            strncpy(sub, buf + 3, 6);
            sub[6] = '\0';

            /* Get transmitter's address & data length */
            temp = 0;
            temp += FEP::ctoi(sub[0])*100;
            temp += FEP::ctoi(sub[1])*10;
            temp += FEP::ctoi(sub[2])*1;
            FEP::_transmitterAddr = temp;
            temp = 0;
            temp += FEP::ctoi(sub[3])*100;
            temp += FEP::ctoi(sub[4])*10;
            temp += FEP::ctoi(sub[5])*1;
            data_len = temp;
            /* Store binary data to array */
            if (data_len > len) {
                /* received data is too long! */
                return FEP_DT_ERR;
            }
            /* memcpy(str, buf + 9, data_len); */
            for (i = 0; i < data_len; i++) {
                data[i] = buf[i + 9];
            }

            /* Get intensity part of string */
            strncpy(sub, buf + 9 + data_len, 3);
            sub[3] = '\0';

            data_mode = FEP_DT_BIN;
        }

        temp = 0;
        temp += FEP::ctoi(sub[0])*100;
        temp += FEP::ctoi(sub[1])*10;
        temp += FEP::ctoi(sub[2])*1;
        FEP::_intensity = temp;
    }

    return data_mode;
}

uint8_t FEP::getTransmitterAddr()
{
    return FEP::_transmitterAddr;
}

uint8_t FEP::getIntensity()
{
    return FEP::_intensity;
}

uint8_t FEP::read(char *data, uint8_t len)
{
    char str[FEP_LINE_LEN];
    uint8_t temp;
    temp = FEP::gets(str, (len*2+2));
    if(temp == FEP_DT_STR) {
        if(str[0] == 'G' && str[(len*2+2)-1] == 'H') {
            FEP::hex2dec(str,data,len);
            return 0;
        } else {
            return 1;
        }
    } else if(temp == FEP_DT_BIN) {
        return FEP_DT_BIN;
    } else if(temp == FEP_DT_ERR) {
        return FEP_DT_ERR;
    } else {
        return FEP_NO_RESPONSE;
    }
}

uint8_t FEP::reset()
{
    uint8_t response;
    FEP::serial.printf("@RST\r\n");
    response = FEP::getResponse();
    while(response != FEP_P0) {
        response = FEP::getResponse();
    }
    return response;
}
