/** @author 五十嵐幸多
 *
 * ２進数の操作を楽にしたかったので作りました。
 * 主に、送受信のデータを1byteずつに分けたり、結合したりします。
 */
#ifndef DATACONTROL

#define DATACONTROL
#include "mbed.h"

/// 2進数の操作ができるクラスです。
class DataControl
{
public:

    /** コンストラクタ
     *
     * 何の変哲もないコンストラクタです。初期化用。
     */
    DataControl();

    /** 16bitデータを8bitずつに分ける関数
     *
     * uint16_t型のデータを8bitに分けて配列arrayに格納します。
     * @param data 分けたいデータ
     * @param *array 分けたデータを格納する配列
     */
    void dataSeparate(uint16_t data, char* array);

    /** データを結合する関数
     *
     * 受信したデータを結合してint型で返すやつです。
     * @param *array 受信したデータの配列
     * @param _data_size 結合したいデータのサイズ(byte) 例:int型 → 4
     * @return int 受信したデータ
     */
    int dataCombine(unsigned char *array, int _data_size);

    /** 送信するデータをセットする関数
     *
     * 送信したいデータをセットします。
     * @param data セットしたいデータ
     * @param *data_array 送信するデータの配列
     * @note 関数のオーバーロードを使っていろんな型のデータをセットできます。
     *       現時点ではchar型、uint16_t型、int型を実装しています。
     */
    void dataSet(char data, char *data_array);
    void dataSet(uint16_t data, char *data_array);
    void dataSet(int data, char *data_array);

protected:

    /// dataSetの際にデータのbyte数が格納されます。
    size_t separated_data_size;
    
    /// データ結合用変数。いじる必要はありません。
    int dataBuff[5];

};

#endif

