
#include "DataControl.h"

DataControl::DataControl()
{
    separated_data_size = 0;
    for(int i=0; i<5; i++) dataBuff[i] = 0;
}


/*---bit cotrol---*/

void DataControl::dataSeparate(uint16_t data, char* array)
{
    array[0] = data & 0xFF;
    array[1] = (data & 0xFF00) >> 8;
}

int DataControl::dataCombine(unsigned char *array, int _data_size)
{
    for(int i=0; i<5; i++) dataBuff[i] = 0;
    for(int i=0; i<_data_size-1; i++) {
        dataBuff[i] = array[i];
        dataBuff[4] |= dataBuff[i] << (i*8);
    }
    return dataBuff[4];
}

/*---end---*/



/*---dataSet function---*/

void DataControl::dataSet(int data, char *data_array)
{
    separated_data_size = sizeof(data) + 1; // 4
    dataSeparate(data & 0xFFFF, data_array);
    dataSeparate((data & 0xFFFF0000) >> 16, &data_array[2]);
}


void DataControl::dataSet(uint16_t data, char *data_array)
{
    separated_data_size = sizeof(data) + 1; // 2
    dataSeparate(data, data_array);
}

void DataControl::dataSet(char data, char *data_array)
{
    separated_data_size = sizeof(data) + 1; // 1
    data_array[0] = data;
}


/*---end---*/