#include "mbed.h"
#include "FEP.h"

BusIn onSW(PA_4,PA_5,PB_5,PB_4,PB_3,PA_15,PA_12);
BusIn otherSW(PC_13,PC_14,PB_9,PC_15,PA_11,PA_1);
AnalogIn Stick[4]={PA_6,PA_7,PB_0,PB_1};
FEP fep(PA_2,PA_3,000);
//FEP fep(PB_10,PB_11,000);
Serial xbee(PA_9,PA_10,38400);
Serial pc(PB_10,PB_11,115200);
DigitalOut leds[4]={PB_15,PB_14,PB_13,PB_12};

void LED_allOFF(){
    int i;
    for(i=0;i<4;i++){
        leds[i]=1;
    }
}

void getInputState(double stick_val[],uint8_t SW_val[]){
    int i;
    SW_val[0]=onSW;
    SW_val[1]=otherSW;
    for(i=0;i<4;i++){
        stick_val[i]=Stick[i];
    }
}

void convertTXdata(double stick_val[],uint8_t SW_val[],char TXdata[]){
    int i;
    for(i=0;i<4;i++){
        TXdata[i]=255*stick_val[i];
    }
    TXdata[4]=SW_val[0];
    TXdata[5]=SW_val[1];
}


int main() {
    onSW.mode(PullUp);
    otherSW.mode(PullUp);
    LED_allOFF();
    double stick_val[4];
    uint8_t SW_val[2];
    char TXdata[128];
    uint8_t FEPstate;
    while(1) {
        getInputState(stick_val,SW_val);
        convertTXdata(stick_val,SW_val,TXdata);
        FEPstate=fep.puts(TXdata,6);
        leds[3]!=leds[3];
        if(FEPstate==FEP_P0){
            leds[0]=0;
            leds[1]=1;
            leds[2]=1;
            continue;
        }else if(FEPstate==FEP_N0){
            leds[0]=1;
            leds[1]=0;
            leds[2]=1;
            continue;
        }else if(FEPstate==FEP_N1){
            leds[0]=1;
            leds[1]=1;
            leds[2]=0;
            continue;
        }else{
            leds[0]=1;
            leds[1]=1;
            leds[2]=1;
        }
    }
}
