#ifndef MDC3_0_PIN_CONFIG
#define MDC3_0_PIN_CONFIG

namespace pinConfig
{
    /* Serial for debug etc */
    static PinName const UART1_TX = PA_9;
    static PinName const UART1_RX = PA_10;

    /* Serial and DigitalOut for RS-485 interface */
    static PinName const RS485_TX = PB_10;
    static PinName const RS485_RX = PB_11;
    static PinName const RS485_CS = PA_8;

    /* I2C */
    static PinName const I2C_SDA = PB_8;
    static PinName const I2C_SCL = PB_9;

    /* CAN */
    static PinName const CAN_TX = PA_12;
    static PinName const CAN_RX = PA_11;

    /* dip switch input */
    static PinName const DIP_0 = PB_4;
    static PinName const DIP_1 = PB_5;
    static PinName const DIP_2 = PB_6;

    /* Buzer */
    static PinName const BUZER = PB_7;

    /* Indicator LEDs */
    static PinName const LED_0 = PA_0;
    static PinName const LED_1 = PA_1;
    static PinName const LED_2 = PA_15;
    static PinName const LED_3 = PB_3;

    /* Motor signal */
    /* ch0 */
    static PinName const DIR_L_0 = PA_2;
    static PinName const DIR_H_0 = PA_3;
    static PinName const PWM0   = PA_6;
    /* ch1 */
    static PinName const DIR_L_1 = PA_4;
    static PinName const DIR_H_1 = PA_5;
    static PinName const PWM1   = PA_7;
    /* ch2 */
    static PinName const DIR_L_2 = PB_12;
    static PinName const DIR_H_2 = PB_13;
    static PinName const PWM2   = PB_0;
    /* ch3 */
    static PinName const DIR_L_3 = PB_14;
    static PinName const DIR_H_3 = PB_15;
    static PinName const PWM3   = PB_1;
};
#endif /* MDC3.0_PIN_CONFIG */