#include "mbed.h"
#include "pinconfig.h"
#include "QEI.h"
#include "R1370.h"
#include "can_tr.h"

Serial pc(USBTX, USBRX, 115200);
QEI enc1(encoder1_A, encoder1_B, NC, 100, QEI::X4_ENCODING);
QEI enc2(encoder2_A, encoder2_B, NC, 100, QEI::X4_ENCODING);
QEI enc3(encoder3_A, encoder3_B, NC, 100, QEI::X4_ENCODING);
QEI enc4(encoder4_A, encoder4_B, NC, 100, QEI::X4_ENCODING);
R1370 r1370(jyro_TX,jyro_RX);
DigitalOut Reset(PA_8);
DigitalOut led(LED2);

void updateenc(){
    encoderValue[8] = (float)enc1.getPulses();
    encoderValue[9] = (float)enc2.getPulses();
    encoderValue[10] = (float)enc3.getPulses();
    encoderValue[11] = (float)enc4.getPulses();
    for (int i=8; i<12; i++) pc.printf("%d  ", encoderValue[i]);
}

void updatejyro(){
    r1370.update();
    jyroValue=r1370.getAngle();
    pc.printf("%f  ",jyroValue);
}

int main()
{
    
    led = 1;
    printf("success!\r\n");
    
    while(1) { 
        Reset=0;   
        updateenc();
        updatejyro();
        pc.printf("\r\n ");
        canTR();
    }
}