
#include "mbed.h"
#include "ikarashiCAN.h"
#include "pinconfig.h"

ikarashiCAN icanR(canrRD, canrTD, 1);
ikarashiCAN icanT(cantRD, cantTD, 2);

/*センサ及びアクチュエータの変数*/
double motorSpeed[16];
/*
 0:使用不可
 1:sub2　旋回
 2:sub2　上下
 3:死
 4:sub2　細木昇降
 5:sub2　　　押し出し
 6:sub2　　　ローラー正
 7:sub2　　　ローラー負
 8:main　足回り右前
 9:main　　　　左前
10:main　　　　左後　　　
11:main　　　　右後
12:main　関昇降
13:main　　押し出し
14:main　　射出
15:空き
*/
int encoderValue[12];
/*
0:sub2　旋回
1:sub2　上下
2:sub2　細木昇降
3:sub2　　　押し出し
4:main　関昇降
5:main　　押し出し
6:main　　射出
*/
uint8_t b[8];
int16_t stick[4];
double jyroValue;
/*************************/

int recievedMotorSpeed[16];
int recievedJyroValue = 0;
int sendCnt = 1;


void canAllReset()
{
    for(int i=0; i<16; i++) {
        motorSpeed[i] = 0;
        recievedMotorSpeed[i] = 0;
        if(i < 12) encoderValue[i] = 0;
        if(i < 8) b[i] = 0;
        if(i < 4) stick[i] = 0;
    }
    recievedJyroValue = 0;
}

void canAllRecieve()
{
    if(icanR.checkReciever()) {
        for(int i=0; i<16; i++) {
            //モーターの各値を取得
            icanR.ifOriginalGet(recievedMotorSpeed[i], i+1);
            motorSpeed[i] = recievedMotorSpeed[i];
            motorSpeed[i] /= 10;


            //エンコーダの各値を取得
            if(i < 12) {
                icanR.ifOriginalGet(encoderValue[i], i+16+1);
            }

            //コントローラーのボタンの値を取得
            if(i < 8) {
                icanR.ifOriginalGet(b[i], i+29);
            }

            //コントローラーのスティックの値を取得
            //左Y軸[0] X軸[1]、　右Y軸[2] X軸[3]
            if(i < 4) {
                icanR.ifOriginalGet(stick[i], i+37);
            }
        }
        //ジャイロの値を取得
        icanR.ifOriginalGet(recievedJyroValue, 41);
        jyroValue = recievedJyroValue;
        jyroValue /= 10000;
    }
}

void canAllSet()
{
    if(sendCnt >= 41) {
        icanT.setData((int)(jyroValue * 10000));
        icanT.originalSet(41);
        sendCnt = 1;
    } else if(sendCnt >= 37) {
        icanT.setData(stick[sendCnt - 37]);
        icanT.originalSet(sendCnt);
    } else if(sendCnt >= 29) {
        icanT.setData(b[sendCnt - 29]);
        icanT.originalSet(sendCnt);
    } else if(sendCnt >= 17) {
        icanT.setData(encoderValue[sendCnt - 17]);
        icanT.originalSet(sendCnt);
    } else {
        icanT.setData((int)(motorSpeed[sendCnt - 1] * 10));
        icanT.originalSet(sendCnt);
    }
    sendCnt++;
}

/*********************/
void canTR(){
    canAllSet();
    icanT.send();
    icanR.recieve();   
    canAllRecieve();
}
/*********************/
