//PS4コントローラーにしわき拡張版
#include "FEP_TX22.h"
#include "SerialArduino.h"
#include "pinconfig.h"
#define SWNUM 8
#define DATANUM 128

SerialArduino mini(TXino, RXino, 115200);

//FEP,PCの宣言
FEP_TX22 FEP_TX22(fepTX, fepRX, fepad);
Serial pc(USBTX, USBRX, 115200);

//拡張部の宣言
AnalogIn volume1(vol1);
AnalogIn volume2(vol2);
AnalogIn volume3(vol3);
DigitalIn stop(em_stop);
DigitalIn toggle1(tgl1);
DigitalIn toggle2(tgl2);
DigitalIn toggle3(tgl3);

int main()
{
    uint8_t data[DATANUM];
    while(1)
    {
        mini.getState(data);
        data[9] = (int)(volume1*255);   //左
        data[10] = (int)(volume2*255);  //中
        data[11] = (int)(volume3*255);  //右
        data[12] = stop;                //上
        data[13] = toggle1;             //左
        data[14] = toggle2;             //中
        data[15] = toggle3;             //右
        //PC表示部分
        pc.printf("%3d | sw:%3d %3d | stick:%3d %3d %3d %3d | trig:%3d %3d  | vol:%3d %3d %3d | tgl:%3d %3d %3d | %3d\r\n"
        , data[12], data[0], data[1], data[2], data[3], data[4], data[5], data[6], data[7], data[9], data[10], data[11], data[13], data[14], data[15], data[8]);
        
        FEP_TX22.SendData(data, 16);
    }
}