#include "FEP_RX22.h"
#include "pinconfig.h"

FEP_RX22 mycon(PC_12, PD_2, 004);
Serial pc(pcTX, pcRX, 115200);

int main()
{
    mycon.StartReceive();
    uint8_t b[16];
    int16_t stick[4];
    int16_t trigger[4];
    uint8_t timeout;
    uint8_t datalen;
    uint8_t data[128];
    while(1) {
        
#if ControllerMode
        for (int i=0; i<16; i++) b[i] = mycon.getButton(i);
        for (int i=0; i<4; i++) stick[i] = mycon.getStick(i);
        for (int i=0; i<2; i++) trigger[i] = mycon.getTrigger(i);
        
        for (int i=0; i<16; i++) pc.printf("%d ", b[i]);
        pc.printf(" | ");
        for (int i=0; i<4; i++) pc.printf("%3d ", stick[i]);
        pc.printf(" | ");
        for (int i=0; i<2; i++) pc.printf("%3d ", trigger[i]);
        pc.printf(" | ");
#else
        datalen = mycon.getData(data);
        for (int i=0; i<datalen; i++) {
            pc.printf("%3d, ", data[i]);
        }
#endif
        
        timeout = mycon.getTimeout();
        pc.printf("%3d | ", timeout);
        if (mycon.getStatus()) pc.printf("received\r\n");
        else pc.printf("anything error...\r\n");
        
    }
}