//PS4コントローラーにしわき拡張版
#include "FEP_RX22.h"
#include "pinconfig.h"
#include <cmath>

FEP_RX22 mycon(fepTX, fepRX, fepad);
Serial pc(pcTX, pcRX, 115200);

int main()
{
    mycon.StartReceive();
    uint8_t b[16];
    int16_t stick[4];
    int16_t trigger[4];
    int16_t volume[3];
    uint8_t toggle[4];
    uint8_t timeout;
    uint8_t data[128];
    int pw;
    while(1) {
        
#if ControllerMode
        for (int i=0; i<16; i++) b[i] = mycon.getButton(i);
        for (int i=0; i<4; i++) stick[i] = mycon.getStick(i);
        for (int i=0; i<2; i++) trigger[i] = mycon.getTrigger(i);
        
        for (int i=0; i<16; i++) pc.printf("%d ", b[i]);
        pc.printf(" | ");
        for (int i=0; i<4; i++) pc.printf("%3d ", stick[i]);
        pc.printf(" | ");
        for (int i=0; i<2; i++) pc.printf("%3d ", trigger[i]);
        pc.printf(" | ");
#else
        mycon.getData(data);
        for (int i=0, tmp=1; i<8; i++) {
            pw = pow((float)2,i);
            b[i] = (int)((data[0] & tmp)/pw);
            pc.printf("%d ", b[i]);
            tmp *= 2;
        }
        for (int i=8, tmp=1, j=0; i<16; i++, j++) {
            pw = pow((float)2,j);
            b[i] = (int)((data[1] & tmp)/pw);
            pc.printf("%d ", b[i]);
            tmp *= 2;
        }
        pc.printf(" | ");
        
        for (int i=0; i<4; i++) {
            stick[i] = data[i+2];
            pc.printf("%3d ", stick[i]);
        }
        pc.printf(" | ");
        
        for (int i=0; i<2; i++) {
            trigger[i] = data[i+6];
            pc.printf("%3d ", trigger[i]);
        }
        pc.printf(" | ");
        
        for (int i=0; i<3; i++) {
            volume[i] = data[i+9];
            pc.printf("%3d ", volume[i]);
        }
        pc.printf(" | ");
        
        for (int i=0; i<4; i++) {
            toggle[i] = data[i+12];
            pc.printf("%3d ", toggle[i]);
        }
        pc.printf(" | ");
        
        timeout = data[8];
        pc.printf("%3d ", timeout);
        pc.printf(" | ");
        
#endif
        if (mycon.getStatus()) pc.printf("received\r\n");
        else pc.printf("anything error...\r\n");
        
    }
}