#ifndef CONTROL_PARAMETER_H
#define CONTROL_PARAMETER_H

#define LPF_C_TIME  1.0/60 //制御周期
#define LPF_A_TIME  0.15   //到達時間
#define MOT_C_TIME  1.0/60
#define MOT_A_TIME  0.15

//振り子のスピード
#define FIRST_POWER         0.8
#define SECOND_POWER        0.95
#define THIRD_POWER         1.0
//振り子振る間隔
#define FIRST_WAIT          0.15
#define SECOND_WAIT         0.25
#define THIRD_WAIT          0.35

#define FURIKO_STOP_LINE    73     //ふり幅
#define SET_WAIT            0.15   //ロリコン依存で振り切った後の待ち時間
#define SECOND_LINE         1      //firstからsecondに移行するための時間
#define THIRD_LINE          2      //secondからthirdに移行するための時間
#define JUMP_TIME           14.5     //飛ぶために必要そうな時間
#define JUMP_LINE           -45    //飛ぶために必要そうなエンコーダーのタイミング
#define RELEASE_LINE        70     //離す瞬間のZ軸の加速度、重力に逆らうので98より小さくなるはず
//ロープ検知の閾値
#define PH_LINE1            0.1
#define PH_LINE2            0.2
#define PH_LINE3            0.6

#define NEXT_PALSE          130    //飛んだあとの基準
const double ROPE_ACRROS[3]={PH_LINE1,PH_LINE2,PH_LINE3};

#define PI  3.14159265358979       //梅沢追加　円周率の定義

#endif