#include "controller.h"
#include "pinconfig.h"

Bcon mycon(fepTX, fepRX, fepad);
Serial pc(pcTX, pcRX, 115200);

int main()
{
    mycon.StartReceive();
    uint8_t b[8];
    int16_t stick[4];
    while(1) {
        for (int i=0; i<8; i++) b[i] = mycon.getButton(i);
        for (int i=0; i<4; i++) stick[i] = mycon.getStick(i);
        
        for (int i=0; i<8; i++) pc.printf("%d ", b[i]);
        pc.printf(" | ");
        for (int i=0; i<4; i++) pc.printf("%3d ", stick[i]);
        pc.printf(" | ");
        if (mycon.status) pc.printf("received\r\n");
        else pc.printf("anything error...\r\n");
    }
}