#include "mbed.h"
#include "Bcon.h"
#include "pinconfig.h"
#define SWNUM 8


//バスインの宣言
BusIn Button(Ltop, Lleft, Lbtm, Lright, Rtop, Rleft, Rbtm, Rright);
//スティックのアナログイン宣言
AnalogIn stick[]={Lx, Ly, Rx, Ry};

//FEP,PCの宣言
Bcon bcon(fepTX, fepRX, fepad);
Serial pc(USBTX, USBRX, 115200);


int main()
{
    double stick_val[4];
    bool sw[SWNUM];// 各ボタン表示用
    uint8_t data[256]={}, sum;//data 送る, sum BusIn値
    uint8_t data_[5];
    Button.mode(PullDown);
    while(1)
    {
        //スティックの値を代入
        for(int i=0; i<4; i++){
            stick_val[i]=stick[i];
        }

        //ｽｲｯﾁ各個表示
        sum = Button & Button.mask();
        for (int i=0; i<SWNUM; i++) {
            sw[i] = (sum>>i) & 1;
        }
        
        //スイッチ,スティック,トリガーを変数にいれる
        for (int i=0; i<2; i++) {
            data[i] = sum;
        }
        
        for (int i=0; i<4; i++) {
            data[2+i] = stick_val[i]*255;
        }
        
        for (int i=0; i<2; i++) {
            data[6+i] = 50*(i+1);
        }
        
        //PC表示部分
        pc.printf("sw:%3d %3d | stick:%3d %3d %3d %3d | trig:%3d %3d\r\n"
        , data[0], data[1], data[2], data[3], data[4], data[5], data[6], data[7]);
        
        data_[0] = sum;
        for (int i=1; i<5; i++) {
            data_[i] = stick_val[i-1]*255;
        }
        
        bcon.SendData(data_);
    }
}