/**
 *  @file   FEP.cpp
 *  @author 安澤瑠
 *  @date   21/10/16
 */
#include "controller.h"

Bcon::Bcon(PinName tx, PinName rx, uint8_t addr_, int baud) :
    RawSerial(tx, rx, baud)
{
    addr     = addr_;
    timeout  = TIMEOUT_COUNT;
    bufindex = 0;
    retindex = 0;
}

void Bcon::StartReceive()
{
    attach(callback(this, &Bcon::ReceiveBytes));
    timeoutTimer.attach(callback(this, &Bcon::TimeoutLoop), 0.1);
}

void Bcon::TimeoutLoop()
{
    if (timeout >= TIMEOUT_COUNT) {
        status = false;
    } else {
        status = true;
        timeout++;
    }
}

void Bcon::ReceiveBytes()
{
    buffer[bufindex] = getc(); // Receive 1byte
    timeout = 0;

    if ( (!strncmp((char*)(buffer + ((256 + bufindex - 1)%256) ), "\r\n", 2)) ) { // <CR><LF> bufindex = <LF>(='\n')
        CheckData(); // check and extract message
    }
    bufindex++;
}

void Bcon::CheckData()
{
    uint8_t temp=0;
    for (uint16_t i=0; i<256; i++) {
        temp = (256 + bufindex - i) % 256;
        if ( !strncmp((char*)(buffer + temp) , "RBN", 3) ) { // check header  temp='R'
        /* コントローラの仕様変更時はここを変える */
            sum = buffer[(temp+9)%256];
            for (int j=0; j<4; j++) {
                stick[j] = buffer[(temp+10+j)%256];
            }
            
            return;
        }
    }
}


void Bcon::GetData(uint8_t *data)
{
    for (int i=0; i<DATANUM; i++) data[i] = retdata[i];
}

bool Bcon::getButton(uint8_t n)
{
    return (sum>>n) & 1;
}

int16_t Bcon::getStick(uint8_t n)
{
    if (n%2) return 128-stick[n];
    else return stick[n]-128;
}