#include "mbed.h"
#include "IRsensor.h"
#include "TFmini.h"
#include "QEI.h"
#include "SerialMultiByte.h"
#include "pinconfig.h"

union UnionBytes{
    uint8_t bytes[28];
    float IRdistance[7];    //0~1
    int32_t TFdistance[7]; //2~3
    int32_t pulses[7];     //4~6
};

IRsensor ir[] = {
    IRsensor(IR_0),
    IRsensor(IR_1)
};

TFmini tf[] = {
    TFmini(TF0_TX, TF0_RX),
    TFmini(TF1_TX, TF1_RX)
};

QEI loli[] = {
    QEI(encoder_1A, encoder_1B, NC, 100, QEI::X4_ENCODING),
    QEI(encoder_4A, encoder_4B, NC, 100, QEI::X4_ENCODING),
    QEI(encoder_3A, encoder_3B, NC, 100, QEI::X4_ENCODING)
};

SerialMultiByte serial(mainTX, mainRX);

Serial pc(USBTX, USBRX, 115200);

int main()
{
    //pc.printf("hello\r\n");
    UnionBytes bytedata;
    uint8_t sendbytes[28];
    for(int i=0; i<28; i++){
        bytedata.bytes[i] = 0;
    }
    for(int i=0; i<2; i++){
        ir[i].startAveraging(10);
    }
    while (1) {
        for(int i=0; i<2; i++){
            bytedata.IRdistance[i] = ir[i].get_Averagingdistance();
            pc.printf("%f ", bytedata.IRdistance[i]);
        }
        for(int i=0; i<2; i++){
            bytedata.TFdistance[i+2] = (int32_t)tf[i].getDistance();
            pc.printf("%d ", bytedata.TFdistance[i+2]);
        }
        for(int i=0; i<3; i++){
            bytedata.pulses[i+4] = (int32_t)loli[i].getPulses();
            pc.printf("%d ", bytedata.pulses[i+4]);
        }
        for(int i=0; i<28; i++){
            sendbytes[i] = bytedata.bytes[i];
        }
        serial.sendData(sendbytes, 28);
        pc.printf("a\r\n");
    }
}
