#ifndef BOT_H
#define BOT_H

#include "mbed.h"
#include "ikarashiMDC.h"
//#include "controller.h"
#include "linemiconget.h"
#include "omni_wheel.h"
#include "OmniPosition.h"
#include "PID.h"
#include "QEI.h"
#include "position_controller.h"
#include "solenoid_valve.h"
#include "petbottleLoading.h"
#include"fep_kinect.h"
#include "pin_config.h"

#define loadingParamator 1955
#define slidorparamotor 1000-127

#define PI 3.141592653589793
#define ADDR 198


//#define angleKP 4.2
//#define angleKI 0.0
//#define angleKD 0.0001
#define angleKP 3.5
#define angleKI 0.0
#define angleKD 0.00005

#define fire1KP 10.8
#define fire1KI 0.095
#define fire1KD 0.00005

#define fire2KP 10.8
#define fire2KI 0.095
#define fire2KD 0.00005

#define XKP 17.0
#define XIP 0//4.0,9.0
#define XDP 0.0004

#define YKP 17.0
#define YIP 0
#define YDP 0.0004

#define frontKP 0.0
#define frontKP 0.0 
#define frontKD 0.0

#define behindKP 0.4 
#define behindKI 0.0
#define behindKD 0.00015

#define RATE 0.01
#define PI 3.14159265

#define  KA  0.95

//#define MOTOR_MODE_STOP      0
//#define MOTOR_MODE_FORWARD   1
//#define MOTOR_MODE_BACKWARD  2
//#define MOTOR_MODE_RIGHT     3
//#define MOTOR_MODE_LEFT      4

#define table2400X 2133
#define table2400Y -4755
#define table1800X 7756
#define table1500X 6464
#define table1200X 5160
#define dash1X      1063
#define dash1Y      -2113
#define dash2X      1046
#define dash2Y      -4618
#define dash3X      2465
#define dash3Y      -4609

#define wallmodeY -4300
#define walldashY -4700
#define wallslide 0.3




class GakuBot
{
public:
    GakuBot();
    void botConfirm();
    void controllerMode1();
    void controllerMode2();
    void controllMech1();
    void controllMech2();
    void autoMode1();
    void autoMode2();


    void controllMech();

private:
    DigitalOut led;
    
    /*PID系*/
    PID  fire1Pid, fire2Pid, anglePID, XPid, YPid, distanceFrontPid, distanceBehindPid;

    Serial debugpc;
    /*モータ系*/
    OmniWheel omni;
    DigitalOut RS485control;
    Serial RS485;
    ikarashiMDC* wheels[4];
    ikarashiMDC* fire[2];
    double firePwm[2];
    float stick[4], speed[4];
    
    /*角度系*/
    float Output_PID,Output_PID2,nowAngle, ofsetNowAngle, attachAngle;
    int pullDistance, pullDistanceOfset, nowPals, distanceOfset, distanceOfset2, nowPals2;
    /*受信系*/
//    Controller con;
    bool receiveSuccessed;
    int mode;
    OmniPosition getposition;
    fep_kinect kinect;
    linemiconget lmicon;
    /*座標系*/
    PositionController* conposition;
    
    /*タイマー系*/
    Timer t ,confirmT, pidT;
    double dt, confirmDt;
    PortValve valveFire1, valveFire2;
    Timer pt, fireFrag1time;
    float pdt;
    int fireDistance1,fireDistance2 , loadingmode;
    petbottleLoading loading;
    int airFlag, sw3flag;
    float beforeYaw, yawdegree;
    int yawMode;
    DigitalIn startSW;
    float demoX,demoY;
    int lineCount;
    int getx, gety;
    int fireFlag1, fireFlag2;
    DigitalIn limit1,limit2;
    double X, Y;
    double Xlopass, Xlopassb, Ylopass, Ylopassb, targetradians;
    int Xdemo[5], Ydemo[5], demomode;
    int movetablemode, firecount, fireFlag, modeFlag;
    int solenoidValve1is, solenoidValve2is , dpetbotle;
    float fireMDCPwm[2], piddt;
    int start_;
    int suzuki[3];
    int kabeFlag;
    int kinectmode, kinectDistance;
    int kinectFlag, swflag;
    
};


#endif//BOT_H