#include "mbed.h"
#include "StaticDefs.hpp"

////////////////////////////////////////////////////////////////// NEW TICKER
Ticker systemTicker;
bool setup_complete = false;
volatile unsigned int bTick = 0;
volatile unsigned int timer_counter = 0;

static unsigned int read_ticker(void) {      //Basically this makes sure you're reading the data at one instance (not while it's changing)
    unsigned int val = bTick;
    if( val )
        bTick = 0;
    return( val );
}
////////////////////////////////////////////////////////////////// NEW TICKER

volatile bool fsm_loop = false; //used so the compiler does not optimize this variable (load from memory, do not assume state of variable)
volatile bool log_loop = false; //used so the compiler does not optimize this variable (load from memory, do not assume state of variable)

void loop_trigger() { fsm_loop = true;} // loop trigger (used in while loop)
void log_loop_trigger() { log_loop = true;} // log loop trigger (used in while loop)

static int current_state = 0; 
static int have_legfile = 0;    
static bool file_opened = false;

void FSM() {                    // FSM loop runs at 10 hz
    if(fsm_loop) {
        // led one removed
        fsm_loop = false;       // wait until the loop rate timer fires again
        current_state = stateMachine().runStateMachine();       //running State Machine. Returns 0 if sitting idle or keyboard press (SIT_IDLE state).
    }
}

void log_function() {    
    // log loop runs at 1 hz
    if (log_loop) {  //start logloop8
        //when the state machine is not in SIT_IDLE state (or a random keyboard press)
        
        if(current_state != 0) {  //first if  - not in sit_idle/keyboard state
            if (!file_opened) {                                 //if the log file is not open, open it
                mbedLogger().appendLogFile(current_state, 1);   //open MBED file once
                //sdLogger().appendLogFile(current_state, 0);     //open SD file once
                           
                file_opened = true;                             //stops it from continuing to open it

                xbee().printf(">>>>>>>> Recording. Log file re opened. <<<<<<<<\n\r");
            }
            else {
            
                  //just record  to the  Mbed file system   
            
                   mbedLogger().appendLogFile(current_state, 1);    //writing data
                   //sdLogger().appendLogFile(current_state, 1);    //writing data
                 }
        }  //end first if
        
        //when the current FSM state is zero (SIT_IDLE), close the file
        else {  //start first else  for current_state ==0  sit idle/keyboard
            //this can only happen once
            if (file_opened) {
                //WRITE ONCE
                mbedLogger().appendLogFile(current_state, 1);   //write the idle state, then close
                //sdLogger().appendLogFile(current_state, 1);     //write the idle state, then close
                
                mbedLogger().appendLogFile(current_state, 0);    //close log file
                //sdLogger().appendLogFile(current_state, 0);    //close log file
                
                file_opened = false;
                
                xbee().printf(">>>>>>>> Stopped recording. Log file closed. <<<<<<<<\n\r");
            }
        }  //end first else
    }   //END OF LOG LOOP8
    
    log_loop = false;   // wait until the loop rate timer fires again
}

//single system timer to run hardware/electronics timing
static void system_timer(void) {
    bTick = 1;
    
    timer_counter++;
    
    //only start these updates when everything is properly setup (through setup function)
    if (setup_complete) {
        if ( (timer_counter % 5) == 0) {    //this runs at 0.005 second intervals (200 Hz)
            adc().update();  //every iteration of this the A/D converter runs   //now this runs at 0.01 second intervals 03/12/2018
        }
        
        if ( (timer_counter % 10) == 0) {
            bce().update();      //update() inside LinearActuator class (running at 0.01 second intervals)
            batt().update();
        }
        
        if ( (timer_counter % 20) == 0 ) {    // 0.02 second intervals
            rudder().runServo();
        }
        
        if ( (timer_counter % 50) == 0 ) {    // 0.05 second intervals 
            imu().runIMU();
        }
                
        if ( (timer_counter % 100) == 0) {     // 100,000 microseconds = 0.1 second intervals
            depthLoop().runOuterLoop();
            pitchLoop().runOuterLoop();
            headingLoop().runOuterLoop();
        }
        
        if ( (timer_counter % 1000) == 0) {        // update at 1.0 second intervals
            //gui().updateGUI();
        }
        
        if ( (timer_counter % 30000) == 0) {        // update at 30.0 second intervals
            //pc().printf("XB!\n");
        }
    }
}

void setup() {
    //  xbee().baud(115200);  // comment out so default is 9600 for USB communications
    xbee().printf("\n\n\r 2018-11-08 FSG PCB XBee\n\n\r");
    
    //pc().baud(57600);
 
    // start up the system timer
    //systemTimer().start();
 
    // set up and start the adc. This runs on a fixed interval and is interrupt driven
    adc().initialize();
    //one central interrupt is updating the ADC (not using the start function)
    
    // setup and run the rudder(servo) pwm signal (start the ticker)
    //rudder().init();
    xbee().printf("Rudder servo initialized!\n\r");
    
    // set up and start the imu. This polls in the background
    imu().initialize();
    //imu().start();
    
    // construct the MBED local file system
    local();
    
    // construct the SD card file system TEST 10/23/18
    //sd_card();
                   //  mbedLogger().initializeDiagFile();
    // load config data from files
    mbedLogger().setLogTime();
    int print_diag = 0;    // do not print to diag file before it is named
    configFileIO().load_LogVers_config(print_diag);    // version numbers of the log and diag files from "logvers.txt"
    mbedLogger().initializeDiagFile(print_diag);
    print_diag=1;
    configFileIO().load_LogVers_config(print_diag);    // Cnow print info to diag file
    mbedLogger().initializeDiagFile(print_diag);
    
    configFileIO().load_BCE_config();       // load the buoyancy engine parameters from the file "bce.txt"
    configFileIO().load_BATT_config();      // load the battery mass mover parameters from the file "batt.txt"
    
    configFileIO().load_DEPTH_config();     // load the depth control loop parameters from the file "depth.txt" (contains neutral position)
    configFileIO().load_PITCH_config();     // load the depth control loop parameters from the file "pitch.txt" (contains neutral position)
    
    configFileIO().load_RUDDER_config();    // load the rudder servo inner loop parameters from the file "SERVO.txt"
    configFileIO().load_HEADING_config();   // load the rudder servo outer loop HEADING control parameters from the file "HEADING.txt" (contains neutral position)
 
    // set up the linear actuators.  adc has to be running first.
    bce().setPIDHighLimit(bce().getTravelLimit());     //travel limit of this linear actuator
    bce().init();
    //bce().start();  //removed start, it's handled by the interrupt
    bce().runLinearActuator();
    bce().pause(); // start by not moving
 
    batt().setPIDHighLimit(batt().getTravelLimit());    //travel limit of this linear actuator
    batt().init();
    batt().runLinearActuator(); // _init = true;
    //batt().start();//removed start, it's handled by the interrupt
    batt().pause(); // start by not moving
 
    // set up the depth, pitch, and rudder outer loop controllers
    depthLoop().init();
    //removed start, it's handled by the interrupt
    depthLoop().setCommand(stateMachine().getDepthCommand());
 
    pitchLoop().init();
    //removed start, it's handled by the interrupt
    pitchLoop().setCommand(stateMachine().getPitchCommand());
    
    headingLoop().init();           
    //removed start, it's handled by the interrupt
    //headingLoop().setCommand(stateMachine().getHeadingCommand());         // FIX LATER
    //heading flag that adjust the PID error is set in the constructor
    
    //systemTicker.attach_us(&system_timer, 10000);         // Interrupt timer running at 0.01 seconds       (slower than original ADC time interval)
    
    
 
    // show that the PID gains are loading from the file
    xbee().printf("bce    P:%6.2f, I:%6.2f, D:%6.2f, zero %3i, limit %6.1f mm, slope %0.5f  \r\n", bce().getControllerP(), bce().getControllerI(), 
             bce().getControllerD(), bce().getZeroCounts(), bce().getTravelLimit(), bce().getPotSlope());
    xbee().printf("batt   P:%6.2f, I:%6.2f, D:%6.2f, zero %3i, limit %6.1f mm, slope %0.5f  \r\n", batt().getControllerP(),
             batt().getControllerI(), batt().getControllerD(), batt().getZeroCounts(), batt().getTravelLimit(), batt().getPotSlope());
    xbee().printf("rudder min pwm: %6.2f, max pwm: %6.2f, center pwm: %6.2f, min deg: %6.2f, max deg: %6.2f\r\n", rudder().getMinPWM(), rudder().getMaxPWM(), 
            rudder().getCenterPWM(), rudder().getMinDeg(), rudder().getMaxDeg());    
    xbee().printf("depth   P:%6.2f, I:%6.2f, D:%6.2f, offset:%6.1f mm \r\n", depthLoop().getControllerP(), depthLoop().getControllerI(), 
         depthLoop().getControllerD(), depthLoop().getOutputOffset());
    xbee().printf("pitch   P:%6.2f, I:%6.2f, D:%6.2f, offset:%6.1f mm \r\n", pitchLoop().getControllerP(), pitchLoop().getControllerI(),
     pitchLoop().getControllerD(), pitchLoop().getOutputOffset());
    xbee().printf("heading P: %3.2f, I: %3.2f, D %3.2f, offset: %3.1f deg (deadband: %0.1f)\r\n", headingLoop().getControllerP(),
     headingLoop().getControllerI(), headingLoop().getControllerD(), headingLoop().getOutputOffset(), headingLoop().getDeadband());
    
    xbee().printf("\n\r");
         
    //load sequence from file
    sequenceController().loadSequence();
    char buf[256];
    //xbee().printf("\n\n\r 2018-08-14 FSG PCB XBee (setup complete) \n\n\r");
    sprintf(buf, "\n\n\r in setup():  starting legController().loadleg() \n\n\r");
    mbedLogger().appendDiagFile(buf,0);
    have_legfile = legController().loadLeg();
    
    //set time of logger (to current or close-to-current time)   now set earlier  at line 149
    // mbedLogger().setLogTime();
    //sdLogger().setLogTime();
    
    //create log files if not present on file system
    mbedLogger().initializeLogFile();
    
    mbedLogger().appendLogFile(current_state, 1);   //write the idle state, then close
                //sdLogger().appendLogFile(current_state, 1);     //write the idle state, then close
                
                mbedLogger().appendLogFile(current_state, 0);    //close log file  added jcw nov 9 2018 for test
                //sdLogger().appendLogFile(current_state, 0);    //close log file
    //sdLogger().initializeLogFile(); // works 10/23/18
    
    setup_complete = true;    
}

void cycle_logfiles(int logversion, int diagversion) {
   //int logversion;
   //int diagversion;
   char bufx[256];
   sprintf(bufx, "\n\n\r in cycle_logfiles(%d, %d):  starting new diag file. Will add 1 to these values \n\n\r", logversion, diagversion);
  mbedLogger().appendDiagFile(bufx,0);
 mbedLogger().appendLogFile(current_state, 0);  //both files are now closed
       //use the present values and increment
  //logversion =  configFileIO().logFilesStruct.logversion  + 1;  
  //diagversion = configFileIO().logFilesStruct.diagversion  + 1;
  configFileIO().saveLogVersData(logversion+1, diagversion+1);   // updates the file logvers.txt
  configFileIO().load_LogVers_config(0);    // now read them back into the structure
  mbedLogger().initializeDiagFile(0);      //don't print before initializing
  
  
  mbedLogger().initializeLogFile();
  mbedLogger().initializeDiagFile(1);
   
}  

/*************************** v1.8 **************************/

int main() {   
    setup();    //setup electronics/hardware
    // on landing, check orientation, if upside down, fix that first
    systemTicker.attach_us(&system_timer, 1000);         // Interrupt timer running at 0.001 seconds       (slower than original ADC time interval)
    
    unsigned int tNow = 0;
    int vernum=0;
    int diagnum=0;
     char buf[256];
    xbee().printf("\n\n\r 2018-08-14 FSG PCB XBee (setup complete) \n\n\r");
    sprintf(buf, "\n\n\r 2018-08-14 FSG PCB XBee line234main (setup complete) \n\n\r");
    mbedLogger().appendDiagFile(buf,0);
    sprintf(buf, "finished setting up and will exit\n\n\r");
    mbedLogger().appendDiagFile(buf,3);
    //tNow=5; sprintf(buf, "log file config values logfile= %s     diag file= %s\n", configFileIO().logFilesStruct.logFileName,
     //        configFileIO().logFilesStruct.diagFileName); tNow=0;
    mbedLogger().appendDiagFile(buf,3);
    vernum = configFileIO().logFilesStruct.logversion;
    diagnum = configFileIO().logFilesStruct.diagversion;
    sprintf(buf, "translated values LOG FILE VERSION number (vernum)=%d           diag file version number(diagnum) = %d\n", vernum, diagnum);
    mbedLogger().appendDiagFile(buf,3);
    sprintf(buf, "logfiles_struct values - direct LOG FILE VERSION ().logversion=%d           diag file version().diagversion = %d\n", 
    configFileIO().logFilesStruct.logversion,   configFileIO().logFilesStruct.diagversion);
    mbedLogger().appendDiagFile(buf,3);
     sprintf(buf, "try another messgae after closing file up and then will exit\n\n\r");
    mbedLogger().appendDiagFile(buf,0);
    
    
    // increment the log file names once
    //cycle_logfiles(vernum,diagnum);
     //sprintf(buf, "This message should be in a new diag file\n\n\r");
    //mbedLogger().appendDiagFile(buf,0);
    // mbedLogger().appendLogFile(current_state, 1);
    //wait(5);
    //exit(0);
    systemTicker.attach_us(&system_timer, 1000);         // Interrupt timer running at 0.001 seconds       (slower than original ADC time interval)
    int keeprunning = 1;
        
        if(have_legfile) {
            //install the leg variables in a structure, and set the state there.
            stateMachine().getLegParams(); //should set up everything with proper LEG_POSITION_DIVE state
            }
    while (keeprunning) {
        if( read_ticker() ) {                       // read_ticker runs at the speed of 10 kHz (adc timing)
            ++tNow;

            //Note to self: Retest data transmission code.
            //This is currently running at 0.1 second intervals (10 hz) and was working well for data transmission
            if (current_state == TX_MBED_LOG or current_state == RX_SEQUENCE) {
                if ( (tNow % 100) == 0 ) {   // 0.01 second intervals  (100 Hz)
                    fsm_loop = true;
                    FSM();
                }
            } // end if(currentstate..)

            //NOT TRANSMITTING DATA, NORMAL OPERATIONS
            else {  // **88**
                //FSM
                if ( (tNow % 100) == 0 ) {   // 0.1 second intervals
                    fsm_loop = true;
                    FSM();

                    //get commands and update GUI
                    gui().getCommandFSM();
                }
                //LOGGING
                if ( (tNow % 1000) == 0 ) {   // 1.0 second intervals
                    log_loop = true;
                    log_function();
                    sprintf(buf, "hit 1 second  log interval in main loop tNow =%d  \n\n\r", tNow);
                    mbedLogger().appendDiagFile(buf,0);
                }
                //update the log and diagnostics files
                if ( (tNow % 4600) == 0 ) {   // 1.0 hour intervals  check for testing via 7 second intervals
                sprintf(buf, "hit 4.6  second  replace_logfiles interval in main loop tNow =%d  \n\n\r", tNow);
                    mbedLogger().appendDiagFile(buf,0);
                    vernum = configFileIO().logFilesStruct.logversion;
                    diagnum = configFileIO().logFilesStruct.diagversion;
                    sprintf(buf, "cycle log file names at 7.6 seconds. This message should be in old diag file\n\n\r");
                    mbedLogger().appendDiagFile(buf,0);
                  cycle_logfiles(vernum,diagnum);
                    sprintf(buf, "cycled log files at 7 seconds, This message should be in a NEW diag file\n\n\r");
                    mbedLogger().appendDiagFile(buf,0);
                    //  close the log and diagnostics files
                    // increment the version numbers for each
                    //  save the new version numbers
                    // initialize new log and diagnostics files
                    log_loop = true;
                    log_function();
                }
            } // end else { at  **88**
            if(current_state == FB_EXIT) {
                log_loop=true;
                log_function();
                keeprunning=0;  // and this will force exit to the main while() loop.
                sprintf(buf, "INSIDE  main loop: BUT now called to exit out of it via FB_EXIT\n\n\r");
                mbedLogger().appendDiagFile(buf,0);
            }
        }  // end if(read_ticker) {
    }  // end while(keeprunning)
    mbedLogger().appendLogFile(current_state, 1);
    sprintf(buf, "outside of main loop:  exiting out of the leg loop via FB_EXIT\n\n\r");
    mbedLogger().appendDiagFile(buf,0);
    wait(25);

    mbedLogger().appendLogFile(current_state, 1);
    mbedLogger().appendLogFile(current_state, 0);
    sprintf(buf, "wait 25 more seconds? out of the leg loop via FB_EXIT\n\n\r");
    mbedLogger().appendDiagFile(buf,0);
    exit(0);
}  // end main()