#ifndef MBEDLOGGER_HPP
#define MBEDLOGGER_HPP
 
#include "mbed.h"
#include <string>
using namespace std;

#include <vector>

#include <fstream>

enum {
    HEADER_117,
    HEADER_101,
    PACKET_NUM,
    TOTAL_NUM_PACKETS,
    PACKET_SIZE,
    END_TRANSMISSION,
    TRANSMIT_PACKET_1,
    TRANSMIT_PACKET_2,
    PACKET_CRC_ONE,
    PACKET_CRC_TWO,
    RANDOM_CHAR,
    COMMAND_ONE,
    COMMAND_TWO,
    HEADER_1E,
    HEADER_1F,
    PACKET_NO_1,
    PACKET_NO_2,
    END_TX_1,
    END_TX_2
};
//struct for saving names of log and diag files
//struct logFiles {
//    string diagFile;
//    string logFile;
// };

    
class MbedLogger {
public:
    MbedLogger(string file_system_input_string);           //constructor
    
    void createTestLog();   //test log function
    // logFiles logFilesStruct;
    
    void appendLogFile(int current_state, int option);     //check if you have orphaned file pointers before this (file should not be open already)
    void appendDiagFile(char *printf_string, int flushclose);    
    //save float array to file (append each time)
    void saveDataToFile(int input_state, float *input);
    
    //REVISED METHOD to save data (same as OpenLog)
    void recordData(int current_state);
    
    //print the directory to the screen
    void printMbedDirectory();
    
    //print the current MBED log file
    void printCurrentLogFile();
    
    //transmit data when receive confirmation
    void transmitCurrentLogFileLine(bool next_line);
    
    //transmit data when receive confirmation
    //void transmitCurrentLogFile();
    
    // Create the data packet
    void createDataPacket();
    
    // Transmit the data packet
    void transmitDataPacket();
    
    // read transmit packet from Python program
    int readTransmitPacket();
    
    // REOPEN LINE READER
    void reOpenLineReader();
    
    // OPEN LINE READER
    bool openLineReader();
    
    //read packet
    void readPacketInSeries();
    
    //get the number of packets
    int getNumberOfPacketsInCurrentLog();
    
    // END TRANSMISSION AND CLOSE FILE
    void endTransmissionCloseFile();
    
    //open a file to write to it
    void openWriteFile();
    
    bool checkForIncomingData();

    void endReceiveData();

    void copyFileExample();

    int calcCrcOneArray(int *input_array, int array_length);
    int calcCrcTwoArray(int *input_array, int array_length);

    int calcCrcOne();  //used with vector _data_packet, cleaning up later
    int calcCrcTwo();  
    
    int calcCrcOneString (string string_input);

    int calcCrcTwoString (string string_input);
    
    //NEW for logging actual time
    void setLogTime();              //set a local time

    int getSystemTime();          //parse the time to record to the log file
    
    //NEW
    int sendReply();
    void sendReplyPacketNumber(int packet_number);
    
    void resetReplyPacket();
    
    void openNewMissionFile();
    
    void setDataCounter(int input_counter);
    
    void closeIncompleteFile();
    
    void initializeLogFile();
    void initializeDiagFile(int print_diag);  
    
    int fileTransmitState();
    
    int testGetFileSize();
    
    int getFileSize(string filename);
    
    void createEmptyLog();
    
    int debugFileState();
        
    //TICKER AND FUNCTION TO RECEIVE DATA
    void activateReceivePacket();
    void receiveMissionDataWithTicker();
    
    void closeLogFile();    //this sets pointer to null and checks if it is closed otherwise
    void closeDiagFile();
    
    void specifyFileForTransmit(string input_string);
    void transmitFileFromDirectory(int file_number);
    void accessMbedDirectory();
    
    int getFilePointerState();
    void testToggleFilePointer();
    
    bool isTransmissionComplete();
    int currentPacketNumber();
    void eraseFile();
    
    string _received_filename;                  //testing
    
    void receiveSequenceFile();
    void receiveMissionDataWithFSM();           //for use in Finite State Machine
    
    void openReceiveFile(string filename);      //create a file with an input filename
    
    void setTransmissionComplete(bool transmit_complete_status);
    
    void intCreateDataPacket(int data_buffer[],int payload_length);
    
    int getLogSize();   //used in state machine
    
    string _heading_string;
    string _diag_heading_string;
    
    void continuouslyTransmitData();
    
    void continuouslyTransmitDataNoTimer();
    
    void transmitPacketNumber(int line_or_packet_number);
    
    void checkForPythonTransmitRequest();
    
    void fsmTransmitData();
    
    void setTransmitPacketNumber(int packet_number);
    
    void createDataPacket(char line_buffer_sent[], int line_length_sent);
    
    bool endTransmitPacket();   //used to exit FSM with Python
    
    void blastData();
    
    void transmitOnePacket();
    
    void transmitMultiplePackets();
        
private:
    int _file_number;
    
    char _file_name[256];   //file name placeholder
    char _line_buffer[256]; //line buffer used to read file line by line
    
    FILE *_fp;              //the log file pointer
    FILE *_fp2;             // the diag file pointer
    
    vector <int> _data_packet;
    
    std::vector<int>::iterator _it;
    
    int _current_line_length;
    
    int _packet_number;
    int _total_number_of_packets;
    string _log_file_string;    
    
    int _reply_byte;
    int _reply_byte2;
    int _reply_byte3;
    int _reply_byte4;
    int _previous_reply_byte;
    
    bool _file_transmission;        //breaks out of loop in State Machine
    
    float _data_log[37];            //for logging all of the data from the outer and inner loops and so on
    
    int _confirmed_packet_number;
    
    bool _still_transmitting_data;
    
    int _transmit_counter;
    
    int _file_transmission_state;   //needed to test out what's going on with receiver
    
    int _number_of_packets[2];
    
    Ticker _mbed_transmit_ticker;
    Ticker _mbed_receive_ticker;
    
    volatile bool _mbed_transmit_loop;
    volatile bool _mbed_receive_loop;
    
    string _file_system_string;
    string _full_file_path_string;
    string _full_diagfile_path_string;
    
    bool _file_transmission_complete;       //was volatile screwing up the state of this?
    
    int _log_file_line_counter;
    
    int _transmit_packet_num;
    
    bool _fsm_transmit_complete;
    
    bool _end_transmit_packet;
    
    bool _end_sequence_transmission;
};
 
#endif