#include "mbed.h"
#include "StaticDefs.hpp"
//Raspberry Pi reset pin set high at beginning of code
DigitalOut reset_pin(p11,1);

////////////////////////////////////////////////////////////////// NEW TICKER
Ticker systemTicker;
bool setup_complete = false;
volatile unsigned int bTick = 0;
volatile unsigned int timer_counter = 0;

static unsigned int read_ticker(void) {      //Basically this makes sure you're reading the data at one instance (not while it's changing)
    unsigned int val = bTick;
    if( val )
        bTick = 0;
    return( val );
}
////////////////////////////////////////////////////////////////// NEW TICKER

volatile bool fsm_loop = false; //used so the compiler does not optimize this variable (load from memory, do not assume state of variable)
volatile bool log_loop = false; //used so the compiler does not optimize this variable (load from memory, do not assume state of variable)

void loop_trigger() { fsm_loop = true;} // loop trigger (used in while loop)
void log_loop_trigger() { log_loop = true;} // log loop trigger (used in while loop)

static int current_state = 0; 
static int have_legfile = 0; 

static int save_state = 0;   // state to hold while find_neutral runs ( if necessary)
       int begin_state = 0;
static int neutral_via_leg = 0;  // flag for entry of find_neutral via leg_pos and setval==0
static int setval = -1;    // has neutral been set, found in neutral.txt   

static bool file_opened = false;

void FSM() {                    // FSM loop runs at 10 hz
    if(fsm_loop) {
        // led one removed
        fsm_loop = false;       // wait until the loop rate timer fires again
        current_state = stateMachine().runStateMachine();       //running State Machine. Returns 0 if sitting idle or keyboard press (SIT_IDLE state).
    }
}

void log_function(int option) {    
    // log loop runs at 1 hz
    // option =1 normal short output
    // option = 2  longer output, state name and actual time value, etc
    if (log_loop) {  //start logloop8
        //when the state machine is not in SIT_IDLE state (or a random keyboard press)
        if((current_state != SIT_IDLE)   &&  (current_state != FLYING_IDLE)) {  //first if  - not in sit_idle/keyboard state
            if (!file_opened) {                                 //if the log file is not open, open it
                mbedLogger().appendLogFile(current_state, option);   //open MBED file once
                //sdLogger().appendLogFile(current_state, 0);     //open SD file once
                           
                file_opened = true;                             //stops it from continuing to open it

                xbee().printf(">>>>>>>> Recording. Log file re opened. <<<<<<<<\n\r");
            }
            else {
            
                  //just record  to the  Mbed file system   
            
                   mbedLogger().appendLogFile(current_state, option);    //writing data
                   //sdLogger().appendLogFile(current_state, 1);    //writing data
                 }
        }  //end first if
        
        //when the current FSM state is zero (SIT_IDLE), close the file
        else {  //start first else  for current_state ==0  sit idle/keyboard
            //this can only happen once
            if (file_opened) {
                //WRITE ONCE
                mbedLogger().appendLogFile(current_state, option);   //write the idle state, then close
                //sdLogger().appendLogFile(current_state, 1);     //write the idle state, then close
                
                mbedLogger().appendLogFile(current_state, 0);    //close log file
                //sdLogger().appendLogFile(current_state, 0);    //close log file
                
                file_opened = false;
                
                xbee().printf(">>>>>>>> Stopped recording. Log file closed. <<<<<<<<\n\r");
            }
        }  //end first else
    }   //END OF LOG LOOP8
    
    log_loop = false;   // wait until the loop rate timer fires again
}

//single system timer to run hardware/electronics timing
static void system_timer(void) {
    bTick = 1;
    
    timer_counter++;
    
    //only start these updates when everything is properly setup (through setup function)
    if (setup_complete) {
        if ( (timer_counter % 5) == 0) {    //this runs at 0.005 second intervals (200 Hz)
            adc().update();  //every iteration of this the A/D converter runs   //now this runs at 0.01 second intervals 03/12/2018
        }
        
        if ( (timer_counter % 10) == 0) {
            bce().update();      //update() inside LinearActuator class (running at 0.01 second intervals)
            batt().update();
        }
        
        if ( (timer_counter % 20) == 0 ) {    // 0.02 second intervals
            rudder().runServo();
        }
        
        if ( (timer_counter % 50) == 0 ) {    // 0.05 second intervals 
            imu().runIMU();
        }
                
        if ( (timer_counter % 100) == 0) {     // 100,000 microseconds = 0.1 second intervals
            depthLoop().runOuterLoop();
            pitchLoop().runOuterLoop();
            headingLoop().runOuterLoop();
            altimLoop().runOuterLoop();
        }
        
        if ( (timer_counter % 1000) == 0) {        // update at 1.0 second intervals
            //gui().updateGUI();
        }
        
        if ( (timer_counter % 30000) == 0) {        // update at 30.0 second intervals
            //pc().printf("XB!\n");
        }
    }
}
void reset_Pi(){
    reset_pin = 0;
    wait_ms(20);
    reset_pin = 1;
    xbee().printf("\n\rWaking up Raspberry PI\n\r");
}
void setup() {
    //  xbee().baud(115200);  // comment out so default is 9600 for USB communications
    xbee().printf("\n\n\r 2019-13-09 FSG PCB XBee\n\n\r");
    
    //pc().baud(57600);
 
    // start up the system timer
    //systemTimer().start();
 
    // set up and start the adc. This runs on a fixed interval and is interrupt driven
    adc().initialize();
    //one central interrupt is updating the ADC (not using the start function)
    
    // setup and run the rudder(servo) pwm signal (start the ticker)
    //rudder().init();
    xbee().printf("Rudder servo initialized!\n\r");
    
    // set up and start the imu. This polls in the background
    imu().initialize();
    //imu().start();
    
    // construct the MBED local file system
    local();
    
    // construct the SD card file system TEST 10/23/18
    //  need an if test that the sd fileststem setup in staticdefs.cpp succeeded, THEN use the sd filesystem
    //sd_card();
                   //  mbedLogger().initializeDiagFile();
    // load config data from files
    configFileIO().load_StartTime();
    //     mbedLogger().setLogTime();  replaced by call in configfileIO
    int print_diag = 0;    // do not print to diag file before it is named
    configFileIO().load_LogVers_config(print_diag);    // version numbers of the log and diag files from "logvers.txt"
    mbedLogger().initializeDiagFile(print_diag);
    print_diag=1;
    configFileIO().load_LogVers_config(print_diag);    // Cnow print info to diag file
    mbedLogger().initializeDiagFile(print_diag);
        
    configFileIO().load_BCE_config();       // load the buoyancy engine parameters from the file "bce.txt"
    configFileIO().load_BATT_config();      // load the battery mass mover parameters from the file "batt.txt"
    
    configFileIO().load_DEPTH_config();     // load the depth control loop parameters from the file "depth.txt" (contains neutral position)
    configFileIO().load_PITCH_config();     // load the depth control loop parameters from the file "pitch.txt" (contains neutral position)
    
    configFileIO().load_RUDDER_config();    // load the rudder servo inner loop parameters from the file "SERVO.txt"
    configFileIO().load_HEADING_config();   // load the rudder servo outer loop HEADING control parameters from the file "HEADING.txt" (contains neutral position)
    
    char buf[256];
    sprintf(buf, "INIT  of Loop operators line 174 main.cpp   headingLoop().init() is coming\n");
    mbedLogger().appendDiagFile(buf,3);
    
    
    
    
    // set up the linear actuators.  adc has to be running first.
    bce().setPIDHighLimit(bce().getTravelLimit());     //travel limit of this linear actuator
    bce().init();
    //bce().start();  //removed start, it's handled by the interrupt
    bce().runLinearActuator();
    bce().pause(); // start by not moving
 
    batt().setPIDHighLimit(batt().getTravelLimit());    //travel limit of this linear actuator
    batt().init();
    batt().runLinearActuator(); // _init = true;
    //batt().start();//removed start, it's handled by the interrupt
    batt().pause(); // start by not moving
     //char buf[256];
    sprintf(buf, "INIT  of Loop operators line 196 main.cpp   headingLoop().init() is coming\n");
    mbedLogger().appendDiagFile(buf,3);
    
    
    // set up the depth, pitch, and rudder outer loop controllers
    depthLoop().init();
    //removed start, it's handled by the interrupt
    depthLoop().setCommand(stateMachine().getDepthCommand());
 
    pitchLoop().init();
    //removed start, it's handled by the interrupt
    pitchLoop().setCommand(stateMachine().getPitchCommand());
    sprintf(buf, "INIT  of Loop operators line 208 main.cpp   headingLoop().init() is coming\n");
    mbedLogger().appendDiagFile(buf,3);
    
    
    configFileIO().load_setneutral_status();   // "neutral.txt" has flag for whether neutral has been set, and neutral values
    sprintf(buf, "\n in setup():  load_setneutral_status succeeded:    setval = %d \n\r", configFileIO().neutralStruct.setval);
    mbedLogger().appendDiagFile(buf,3);
    setval = configFileIO().neutralStruct.setval;
    sprintf(buf, "\n in setup():  after load_setneutral_status setval = %d \n\r", setval);
    mbedLogger().appendDiagFile(buf,3);
    configFileIO().load_swim_config();      // load in more parameters  bmm_dive_mm, bce, fn_timeout, max_mbed-runtime_hr, altim_blank_m, altim_abort_m
    sprintf(buf, "\n in setup():  after load_swim_config: fn_timeout = %d\n\r", configFileIO().swimConstants.fn_timeout);
    mbedLogger().appendDiagFile(buf,3);
    sprintf(buf, "\n in setup():  after load_swim_config: altim_blank_m = %.1f\n\r", configFileIO().swimConstants.altim_blank_m);
    mbedLogger().appendDiagFile(buf,3);
    sprintf(buf, "\n in setup():  after load_swim_config: bce_dive_mm = %.1f\n\r", configFileIO().swimConstants.bce_dive_mm);
    mbedLogger().appendDiagFile(buf,3);
        sprintf(buf, "depth loop:   P:%6.2f, I:%6.2f, D:%6.2f, offset:%6.1f mm \r\n", depthLoop().getControllerP(), depthLoop().getControllerI(), 
         depthLoop().getControllerD(), depthLoop().getOutputOffset());
    mbedLogger().appendDiagFile(buf,3);
    
    headingLoop().init(); 
    xbee().printf("heading Loop  initialized! line 230\n\r");
    
    sprintf(buf, "INIT  of Loop operators line 230  headingLoop().init() is finished\n");
    mbedLogger().appendDiagFile(buf,3);
    // mbedLogger().appendDiagFile(buf,0);
    
    
    
    configFileIO().load_Altimeter_config();       // load the altimeter filter parameters from the file "altim.txt"  // edit by CAM
    sprintf(buf, "loaded altimeter configuration line 237  \n");
    mbedLogger().appendDiagFile(buf,3);
    sprintf(buf,"line 239:  altimeter reading (meters) = %f\n", sensors().getAltimeterReading_m());
    mbedLogger().appendDiagFile(buf,3);
    mbedLogger().appendDiagFile(buf,0);
  
    xbee().printf("altimeter config loaded  line 245\n\r");
    
    
    altimLoop().init();  
    xbee().printf("altimLoop().init() run  line 247\n\r");
    sprintf(buf, "ran altimLoop().init() after reading config line 244  \n");
    mbedLogger().appendDiagFile(buf,3);
    mbedLogger().appendDiagFile(buf,0);
  
    
    sprintf(buf, "AltimLoop.init() succeeded!  after loading altim.txt values and init()  line 250\n");
    mbedLogger().appendDiagFile(buf,3);  
    
    sprintf(buf, "in setup():  before load_setneutral_status setval = %d   line 253\n\r", setval);
    mbedLogger().appendDiagFile(buf,3);
    mbedLogger().appendDiagFile(buf,0);
    
   
      
 //        
//    configFileIO().load_setneutral_status();   // "neutral.txt" has flag for whether neutral has been set, and neutral values
//    sprintf(buf, "\n in setup():  load_setneutral_status succeeded:    setval = %d \n\r", configFileIO().neutralStruct.setval);
//    mbedLogger().appendDiagFile(buf,3);
//    setval = configFileIO().neutralStruct.setval;
//    sprintf(buf, "\n in setup():  after load_setneutral_status setval = %d \n\r", setval);
//   mbedLogger().appendDiagFile(buf,3);
//    configFileIO().load_swim_config();      // load in more parameters  bmm_dive_mm, bce, fn_timeout, max_mbed-runtime_hr, altim_blank_m, altim_abort_m
//    sprintf(buf, "\n in setup():  after load_swim_config: fn_timeout = %d\n\r", configFileIO().swimConstants.fn_timeout);
//    mbedLogger().appendDiagFile(buf,3);
//    sprintf(buf, "\n in setup():  after load_swim_config: altim_blank_m = %.1f\n\r", configFileIO().swimConstants.altim_blank_m);
//    mbedLogger().appendDiagFile(buf,3);
//    sprintf(buf, "\n in setup():  after load_swim_config: bce_dive_mm = %.1f\n\r", configFileIO().swimConstants.bce_dive_mm);
//    mbedLogger().appendDiagFile(buf,3);
    
    //removed start, it's handled by the interrupt
    //headingLoop().setCommand(stateMachine().getHeadingCommand());         // FIX LATER
    //heading flag that adjust the PID error is set in the constructor
    
    //systemTicker.attach_us(&system_timer, 10000);         // Interrupt timer running at 0.01 seconds       (slower than original ADC time interval)
    
    
 
    // show that the PID gains are loading from the file
    xbee().printf("bce    P:%6.2f, I:%6.2f, D:%6.2f, zero %3i, limit %6.1f mm, slope %0.5f  \r\n", bce().getControllerP(), bce().getControllerI(), 
             bce().getControllerD(), bce().getZeroCounts(), bce().getTravelLimit(), bce().getPotSlope());
    xbee().printf("batt   P:%6.2f, I:%6.2f, D:%6.2f, zero %3i, limit %6.1f mm, slope %0.5f  \r\n", batt().getControllerP(),
             batt().getControllerI(), batt().getControllerD(), batt().getZeroCounts(), batt().getTravelLimit(), batt().getPotSlope());
    xbee().printf("rudder min pwm: %6.2f, max pwm: %6.2f, center pwm: %6.2f, min deg: %6.2f, max deg: %6.2f\r\n", rudder().getMinPWM(), rudder().getMaxPWM(), 
            rudder().getCenterPWM(), rudder().getMinDeg(), rudder().getMaxDeg());    
    xbee().printf("depth   P:%6.2f, I:%6.2f, D:%6.2f, offset:%6.1f mm \r\n", depthLoop().getControllerP(), depthLoop().getControllerI(), 
         depthLoop().getControllerD(), depthLoop().getOutputOffset());
    xbee().printf("pitch   P:%6.2f, I:%6.2f, D:%6.2f, offset:%6.1f mm \r\n", pitchLoop().getControllerP(), pitchLoop().getControllerI(),
     pitchLoop().getControllerD(), pitchLoop().getOutputOffset());
    xbee().printf("heading P: %3.2f, I: %3.2f, D %3.2f, offset: %3.1f deg (deadband: %0.1f)\r\n", headingLoop().getControllerP(),
     headingLoop().getControllerI(), headingLoop().getControllerD(), headingLoop().getOutputOffset(), headingLoop().getDeadband());
    
    xbee().printf("\n\r");
         
    //load sequence from file
    sequenceController().loadSequence();
    
    //xbee().printf("\n\n\r 2018-08-14 FSG PCB XBee (setup complete) \n\n\r");
    sprintf(buf, " in setup():  starting legController().loadleg() \n\n\r");
    mbedLogger().appendDiagFile(buf,3);
    have_legfile = legController().loadLeg();  // this should be 1 if the legfile reader has found 1 or more legs
    
    current_state = legController().legStructLoaded[0].state;
    begin_state = current_state;
    sprintf(buf, "in setup(): have_legfile = %d    current_state = %d (sit_idle= 0 or 1)\n", have_legfile, current_state);
    mbedLogger().appendDiagFile(buf,3);
    sprintf(buf, "in setup(): LEG_POSITION_DIVE = %d   START_SWIM = %d \n", LEG_POSITION_DIVE, START_SWIM);
    mbedLogger().appendDiagFile(buf,3);
    
    sprintf(buf, "Time is a mystery, here is a message before the basic call\n");
    mbedLogger().appendDiagFile(buf,3);
    int jj;
    long int kk;
    time_t secval;
    xbee().printf("legcontroller read  and Time  line 323\n\r");
    sprintf(buf, "sizeof int=%d    size of long int = %d  size of time_t = %d\n", (sizeof jj), (sizeof kk), (sizeof secval));
    mbedLogger().appendDiagFile(buf,3);
    
    secval = mbedLogger().getSystemTime();
    sprintf(buf, "Time as a basic string = %s\n", ctime(&secval));
    mbedLogger().appendDiagFile(buf,3);
    
    sprintf(buf, "Time is still amystery, here is a message after the basic call\n");
    mbedLogger().appendDiagFile(buf,0);
    
    //set time of logger (to current or close-to-current time)   now set earlier  at line 149
    // mbedLogger().setLogTime();
    //sdLogger().setLogTime();
    
    //create log files if not present on file system
    mbedLogger().initializeLogFile();
    
    mbedLogger().appendLogFile(current_state, 2);   //write the idle state, then close
                //sdLogger().appendLogFile(current_state, 1);     //write the idle state, then close
                
                mbedLogger().appendLogFile(current_state, 0);    //close log file  added jcw nov 9 2018 for test
                //sdLogger().appendLogFile(current_state, 0);    //close log file
    //sdLogger().initializeLogFile(); // works 10/23/18
    
    setup_complete = true;    
}

void cycle_logfiles(int logversion, int diagversion) {
   //int logversion;
   //int diagversion;
   char bufx[256];
   sprintf(bufx, "\n\n\r in cycle_logfiles(%d, %d):  starting new diag file. Will add 1 to these values \n\n\r", logversion, diagversion);
  mbedLogger().appendDiagFile(bufx,0);
 mbedLogger().appendLogFile(current_state, 0);  //both files are now closed
       //use the present values and increment
  //logversion =  configFileIO().logFilesStruct.logversion  + 1;  
  //diagversion = configFileIO().logFilesStruct.diagversion  + 1;
  configFileIO().saveLogVersData(logversion+1, diagversion+1);   // updates the file logvers.txt
  configFileIO().load_LogVers_config(0);    // now read them back into the structure
  mbedLogger().initializeDiagFile(0);      //don't print before initializing
  
  
  mbedLogger().initializeLogFile();
  mbedLogger().initializeDiagFile(1);
   
}  

/*************************** v1.8 **************************/

int main() {   
    setup();    //setup electronics/hardware
    // on landing, check orientation, if upside down, fix that first
    // systemTicker.attach_us(&system_timer, 1000);         // Interrupt timer running at 0.001 seconds       (slower than original ADC time interval)
    led2()=1; led4()=0;
    unsigned int tNow = 0;
    int vernum=0;
    int diagnum=0;
     char buf[256];
    xbee().printf("\n\n\r 2018-08-14 FSG PCB XBee (setup complete) \n\n\r");
    sprintf(buf, "\n\n\r 2019-may-07 FSG PCB XBee line315  in main (setup complete) \n\n\r");
    mbedLogger().appendDiagFile(buf,3);
    int fn_timeout = 240; // need to get this into config file
    int save_timeout = 300;
    
    
    //tNow=5; sprintf(buf, "log file config values logfile= %s     diag file= %s\n", configFileIO().logFilesStruct.logFileName,
     //        configFileIO().logFilesStruct.diagFileName); tNow=0;
    //         mbedLogger().appendDiagFile(buf,3);
    vernum = configFileIO().logFilesStruct.logversion;
    diagnum = configFileIO().logFilesStruct.diagversion;
    sprintf(buf, "translated values LOG FILE VERSION number (vernum)=%d           diag file version number(diagnum) = %d\n", vernum, diagnum);
    mbedLogger().appendDiagFile(buf,3);
    sprintf(buf, "logfiles_struct values - direct LOG FILE VERSION ().logversion=%d           diag file version().diagversion = %d\n", 
    configFileIO().logFilesStruct.logversion,   configFileIO().logFilesStruct.diagversion);
    mbedLogger().appendDiagFile(buf,3);
     //sprintf(buf, "try another message after closing file up and then will exit\n\n\r");
    //mbedLogger().appendDiagFile(buf,0);
    
    
    // increment the log file names once
    //cycle_logfiles(vernum,diagnum);
     //sprintf(buf, "This message should be in a new diag file\n\n\r");
    //mbedLogger().appendDiagFile(buf,0);
    // mbedLogger().appendLogFile(current_state, 1);
    //wait(5);
    //exit(0);
    systemTicker.attach_us(&system_timer, 1000);         // Interrupt timer running at 0.001 seconds       (slower than original ADC time interval)
    int keeprunning = 1;
        
        if(have_legfile) {
            //install the leg variables in a structure, and set the state there.
            stateMachine().getLegParams(); //should set up everything with proper LEG_POSITION_DIVE state
            sprintf(buf, "have_legfile succeeded  main: line 318 \n\r");
             mbedLogger().appendDiagFile(buf,3);
            }
        
        if(!have_legfile) {
            sprintf(buf, "have_legfile failed!   .... will exit\n\n\r");
            mbedLogger().appendDiagFile(buf,3);
            keeprunning = 0;
            }
            // another digitalIn option is is_connected()     how can one get both 0 and 1 here?
        if(motorDisconnect().read() == 1) {
            sprintf(buf, "motorDisconnect.read() = 1  surprising!\n\n\r");
            mbedLogger().appendDiagFile(buf,3); led1()=1; led4()=1;
            }
        if(motorDisconnect().read() == 0) {
            sprintf(buf, "motorDisconnect.read() = 0  I expected that\n\n\r");
            mbedLogger().appendDiagFile(buf,3); led1()=1; led3()=1;
            }
  
    while (keeprunning) {
        if( read_ticker() ) {                       // read_ticker runs at the speed of 10 kHz (adc timing)
            ++tNow;

            //Note to self: Retest data transmission code.
            //This is currently running at 0.1 second intervals (10 hz) and was working well for data transmission
            if (current_state == TX_MBED_LOG or current_state == RX_SEQUENCE) {
                if ( (tNow % 100) == 0 ) {   // 0.01 second intervals  (100 Hz)
                    fsm_loop = true;
                    FSM();
                }
            } // end if(currentstate..)

            //NOT TRANSMITTING DATA, NORMAL OPERATIONS
            else {  // **88**
                //FSM
                 setval = configFileIO().neutralStruct.setval;
                       // preamble to running the FSM
                if (setval == 0 && (begin_state != FLYING_IDLE) && ( current_state == LEG_POSITION_DIVE) && (fabs(imu().getRoll()) < 30)) {
                    // begin_state is first state found in setup()
                    //These tests mean: - second start,plus already upright
                    // from setup()  current_state = legController().legStructLoaded[0].state; either start_swim or leg_pos_dive
                    save_state = current_state;
                    neutral_via_leg =1;
                    save_timeout = legController().legStructLoaded[0].timeout;
                    fn_timeout = configFileIO().swimConstants.fn_timeout;
                    current_state = START_SWIM;  // does runStatemachine know about this value?
                    sprintf(buf, "in main(): setval==0, but upright, so pre-empt leg_pos_dive to start_swim\n  set state directly  start_swim\n");
                    mbedLogger().appendDiagFile(buf,3);
                    stateMachine().setstate_frommain(START_SWIM, fn_timeout);  // this will change state inside runstatemachine, change state val inthe right structure, first
                }
                      //setval is now updated in log_data() above,  line 45 or so
                if ( (neutral_via_leg == 1) && (setval == 1) && current_state == RISE) {  // usual endstate of FIND_NEUTRAL new state for after successful find neutral
                    current_state = save_state;   //setval reset at line 366  when find_neutral succeeds
                    stateMachine().setstate_frommain(current_state, save_timeout);   //back to what you were doing
                    sprintf(buf, "in main(): presumably after find_neutral exits to RISE, but successful in setting setval\n");
                    mbedLogger().appendDiagFile(buf,3);
                    neutral_via_leg = 0;
                }
                if ( (neutral_via_leg == 1) && (setval != 1) && current_state == RISE) {  // failed endstate of FIND_NEUTRAL new state
                    
                    sprintf(buf, "in main():  line 409 after find_neutral fail and exits to RISE, UNSUCCESSFULLY\n");
                    mbedLogger().appendDiagFile(buf,3);
                    neutral_via_leg = 0;
                }
                      // end preamble
                if ( (tNow % 100) == 0 ) {   // 0.1 second intervals
                    fsm_loop = true;
                    FSM();

                    //get commands and update GUI
                    gui().getCommandFSM();
                }
                //LOGGING
                if ( (tNow % 1000) == 0 ) {   // 1.0 second intervals
                    log_loop = true;
                    if((tNow % 20000) ==0) {log_function(2);}  // long data string every 20 seconds
                        else {log_function(1); }  //otherwise short
                    // sprintf(buf, "hit 1 second  log interval in main loop tNow =%d  imu.roll = %f not-unsampled \n\n\r", tNow, imu().getRoll());  
                    // mbedLogger().appendDiagFile(buf,3);
                    led3()=0; led2()=0; led1()=0; led4()=0;
                }
                if ( (tNow % 2000) == 0 ) {   // 2 second intervals
                    
                    led3()=1; 
                    sprintf(buf, "main loop:  current_state=%d tNow =%d imu.heading=%f  headingLoop.heading= %f  imu.roll = %f  \n\n\r", 
                                current_state, tNow,imu().getHeading(), headingLoop().getPosition(), imu().getRoll());  
                    mbedLogger().appendDiagFile(buf,3);
                }
                if ((tNow % 3000) == 0) {
                    led2()=1;
                    }
                //update the log and diagnostics files
                if ( (tNow % 31000) == 0 ) {   // 1.0 hour intervals= 3600*1000  check for testing via 31 second intervals
                sprintf(buf, "hit cycle seconds  replace_logfiles interval in main loop tNow =%d  \n\n\r", tNow);
                    mbedLogger().appendDiagFile(buf,3);
                    vernum = configFileIO().logFilesStruct.logversion;
                    diagnum = configFileIO().logFilesStruct.diagversion;
                    sprintf(buf, "cycle log file names at tnow=%d at  seconds. This message should be in old diag file\n\n\r", tNow);
                    mbedLogger().appendDiagFile(buf,3);
                  cycle_logfiles(vernum,diagnum);
                    sprintf(buf, "cycled log files at tNow = %d at seconds, This message should be in a NEW diag file\n\n\r", tNow);
                    mbedLogger().appendDiagFile(buf,3);
                    //  close the log and diagnostics files
                    // increment the version numbers for each
                    //  save the new version numbers
                    // initialize new log and diagnostics files
                    log_loop = true;
                    log_function(2);
                    led3()=1; led1()=1;
                }
            } // end else { at  **88**
            if(current_state == FB_EXIT) {
                log_loop=true;
                log_function(2);
                led2()=1;
                led4()=1;
                keeprunning=0;  // and this will force exit to the main while() loop.
                //  switch state to EOL_WAIT, spit out xbee messages,  wait 60 seconds or so. if keyboard comes back, do not exit
                sprintf(buf, "INSIDE  main loop: BUT now called to exit out of it via FB_EXIT\n\n\r");
                mbedLogger().appendDiagFile(buf,3);
                // and put out the end_leg  message file   
                configFileIO().writeEndleg_reason();
            }
            if(tNow ==  90000) {  // don't wait forever  -remove this for real operations!!
            // if(tNow == 1000 * configFileIO().swimConstants.max_mbed_runtime_hr * 3600) {    
                keeprunning=0;
                
                sprintf(buf, "INSIDE  main loop: Triggered FINAL timeout at 90 seconds\n\n\r");
                mbedLogger().appendDiagFile(buf,3);
                sprintf(buf, "AT FINAL TIMEOUT:  before changing endleg-reason to 8: endleg_reason= %d\n\n\r", configFileIO().swimConstants.endleg_reason);
                mbedLogger().appendDiagFile(buf,3);
                configFileIO().swimConstants.endleg_reason = 8;  //  timed out on mbed_max_runtime_hr
                configFileIO().writeEndleg_reason();
            }
        }  // end if(read_ticker) {
    }  // end while(keeprunning)
    
    mbedLogger().appendLogFile(current_state, 2);
    sprintf(buf, "outside of main loop:  exiting out of the leg loop via FB_EXIT  tNow= %d \n\n\r", tNow);
    mbedLogger().appendDiagFile(buf,3);
    led1()=1; led2() =1; led3()=1 ;led4() = 1;
    wait(5);
    
    mbedLogger().appendLogFile(current_state, 2);
    mbedLogger().appendLogFile(current_state, 0);
    sprintf(buf, "wait 5 more seconds? out of the leg loop via FB_EXIT\n\n\r");
    mbedLogger().appendDiagFile(buf,0);
    led1()=0; led2()=0; led3()= 0 ;led4()=0;
    configFileIO().save_FinalTime();   // saves last time before closing shop
    
    reset_Pi();
    
    exit(0);
}  // end main()