#include "Sensors.hpp"
#include "StaticDefs.hpp"

Sensors::Sensors() {
    _reference_voltage = 5.0;   //check this against actual v_ref
}  
  
    // extrapolated from graph if V_s = 5.0
    // https://www.nxp.com/docs/en/data-sheet/MPXA6115A.pdf   
float Sensors::getInternalPressurePSI() {
    return ( ( 22.029 * ( _reference_voltage * adc().readCh5() / 4095.0 ) + 10.884 ) * 0.145038 ); // Press_Xducer (on-board)
}

float Sensors::getVoltageInput() {
    return ( adc().readCh6() / 4095.0 * _reference_voltage * 7.8 );
}

float Sensors::getCurrentInput() {
    return ( adc().readCh7() / 4095.0 * _reference_voltage );
}

//currently using BCE CS line for this data
float Sensors::getAltimeterChannelReadings() {
    return adc().readCh2();             //channel 2 (third channel) from the schematic
}
float Sensors::getAltimeterReading_m() {   // edit by CAM added by jcw 11sep2019
    return _altimeter_slope * adc().readCh2() + _altimeter_intercept;    
}    

void Sensors::setAltimeterSlope(float S){
    _altimeter_slope = S;
    return;
}

void Sensors::setAltimeterIntercept(float I){
    _altimeter_intercept = I;
    return;
}