#include "mbed.h"
#include "ConfigFile.h"
#include <string>

#ifndef CONFIGFILEIO_HPP
#define CONFIGFILEIO_HPP
struct logFileNames {
    string diagFileName;
    string logFileName;
    int logversion; 
    int diagversion;
};
struct neutralStatus {
     int setval;
     float bce_neutral_mm;
     float batt_neutral_mm;
};
struct swimParams {
     float bce_dive_mm;
     float bce_rise_mm;
     float bmm_dive_mm;
     float bmm_rise_mm;
     int fn_timeout;
     float altim_blank_m;
     float altim_abort_m;
     float max_mbed_runtime_hr;
     int endleg_reason;  //1 = normal timeout  2=yo_timeout  3= altim_abort 4=no_find_neutral  5=still inverted 6=yo_timeout+too slow 7=no_find_neutral+altim_abort
     int altim_abort_count;   //8=mbed_max_runtime_hr  limit
};

    
class ConfigFileIO {
public:
    ConfigFileIO();
    logFileNames logFilesStruct; 
    neutralStatus neutralStruct;
    swimParams swimConstants;
      
    //modified savebatt to save frequency and deadband 7/11/2018
    void saveBattData(float batt_p_gain, float batt_i_gain, float batt_d_gain, int batt_zeroOffset, float batt_filter_freq, float batt_deadband); //modified this because zero offsets are integers
    void savePitchData(float pitch_p_gain, float pitch_i_gain, float pitch_d_gain, float pitch_zeroOffset, float pitch_filter_freq, float pitch_deadband);
    
    void saveBCEData(float bce_p_gain, float bce_i_gain, float bce_d_gain, int bce_zeroOffset, float bce_filter_freq, float bce_deadband);  //modified this because zero offsets are integers
    void saveDepthData(float depth_p_gain, float depth_i_gain, float depth_d_gain, float depth_zeroOffset, float depth_filter_freq, float depth_deadband);
    
    void saveRudderData(float setMinDeg, float setMaxDeg, float setCenterPWM, float setMinPWM, float setMaxPWM);
    void saveHeadingData(float heading_p_gain, float heading_i_gain, float heading_d_gain, float heading_zeroOffset, float heading_filter_freq, float heading_deadband);
    
    //ConfigFunctions
    int load_BCE_config();
    int load_swim_config();
    int load_LogVers_config(int print_diag);    // jcw feb 2019
    void saveNeutralStatus(int setval, float bce_neutral_mm, float batt_neutral_mm);
    int load_setneutral_status();
    int load_Altimeter_config();
    void report_no_neutral_found(float bce_last_pos, float batt_last_pos);
    void writeEndleg_reason();
    void save_FinalTime();
    void report_still_inverted( float roll_value, int yotime);
    void saveLogVersData(int logversion,  int diagversion);
    int load_BATT_config();
    int load_DEPTH_config();
    int load_PITCH_config();
    int load_StartTime();
    int load_HEADING_config();      //heading outer loop of rudder servo
    int load_RUDDER_config();       //rudder servo
    int load_script();

private: 
    float _neutral_batt_pos_mm;
    float _neutral_bce_pos_mm;
};
#endif
