/*
This class wraps an Omega pressure transducer.
Author: Matthew, October 24th, 2013
Modified: Dan, 2017-10-30

WIP: Troy
- added the ability to read the counts from this class directly
- had to fix the class to have the header guard in the header file (#ifndef, #define, #endif)
*/

#include "mbed.h"
#include "omegaPX209.hpp"
#include "StaticDefs.hpp"       //pins and other hardware (new)

omegaPX209::omegaPX209(PinName pin): 
    _adc(pin)   //leaving function as is for now
{
    _psi = 14.7;                    // pressure [psi]
    _zeroPsi = 14.7;                // atmospheric pressure at sea level [psi]
    _adcVoltage = 5.24;              // Troy: I'm not sure this is the right name for this multiplier... [V] (was 3.3 before)
    _fullscale = 50;                // value of sensor at full scale (*confirm with Stearns*) [psi]
    _psi_per_volt_cal = _fullscale/5.0;          // psi per volt calibration [psi/V]
    _PSI_reading = 0;
}

// nothing to initialize, but you can call this function if it makes you feel better.
void omegaPX209::init() {
}

// lets user set a different ambient pressure [psi]
void omegaPX209::setZero(float zeroPsi) {
    _zeroPsi = zeroPsi;    
}

// returns the internal ambient pressure [psi]
float omegaPX209::getZero() {
    return _zeroPsi;
}

// reads from ADC system and does math for converting to psi
float omegaPX209::getPsi() {
    // filter by over-sampling
    float add = 0;
    float adc_reading = 0;
    
    _PSI_reading = 0;   //reset each time
    
    for (int i = 0; i < OVERSAMPLE; i++) {
        // analog input _adc is float 0.0 to 1.0
        // multiplying by _adcVoltage converts percentage to a voltage
        // multiplying by _cal converts voltage to a pressure
        adc_reading = adc().readCh4()/4095.0;
        
        _PSI_reading = adc_reading * _adcVoltage * _psi_per_volt_cal;    //Note: real_voltage_reading = adc_reading * _adcVoltage
        
        add += _PSI_reading;    //replaced _adc.read()
    }
    
    // use over-sampled
    _psi = (add/OVERSAMPLE);

    return _psi;
}

// reads the ADC system and returns depth in feet
float omegaPX209::getDepthFt() {
    float psi = getPsi() - _zeroPsi; // read the sensor and remove atmospheric bias
    float Pa = psi2Pa * psi; // convert psi to Pascals
    float depth_m = Pa / (water_density_kg_m3 * grav_m_s2); // convert Pa to fluid depth in meters
    float depth_ft = m2ft * depth_m; // convert meters to feet

    return depth_ft;
}

// call this if you want to tare to zero
void omegaPX209::tare() {
    setZero(getPsi());
}

// 06/06/2018

int omegaPX209::readADCCounts() {
    //return _adc.read();
    return adc().readCh4();
}

float omegaPX209::readVoltage() {
    float pressure_voltage = adc().readCh4()/4095.0 * _adcVoltage;
    return pressure_voltage;
}

float omegaPX209::getRawPSI() {
    return _PSI_reading;
}