/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 
 /* Includes ------------------------------------------------------------------*/



/* Helper header files. */
#include "DevSPI.h"
void FWD();
void BWD();
void LEFT();
void RIGHT();
void SOFTSTOP();
/* Expansion Board specific header files. */
#include "XNucleoIHM02A1.h"

#include "mbed.h"
#include "ble/BLE.h"
#include "LEDService.h"


/* Definitions ---------------------------------------------------------------*/

/* Number of movements per revolution. */
#define MPR_1 4

/* Number of steps. */
#define STEPS_1 (400 * 128)   /* 1 revolution given a 400 steps motor configured at 1/128 microstep mode. */
#define STEPS_2 (STEPS_1 * 2)

/* Delay in milliseconds. */
#define DELAY_1 1000
#define DELAY_2 2000
#define DELAY_3 5000

#ifdef TARGET_STM32F401
    DevSPI dev_spi(PB_15, PB_14, PB_13);
#else
    DevSPI dev_spi(PB_15, PB_14, PB_13);
#endif
 
/* Variables -----------------------------------------------------------------*/

/* Initialization parameters of the motors connected to the expansion board. */
L6470_init_t init[L6470DAISYCHAINSIZE] = {
    /* First Motor. */
    {
        12.0,                           /* Motor supply voltage in V. */
        200,                           /* Min number of steps per revolution for the motor. */
        1.7,                           /* Max motor phase voltage in A. */
        3.06,                          /* Max motor phase voltage in V. */
        300.0,                         /* Motor initial speed [step/s]. */
        500.0,                         /* Motor acceleration [step/s^2] (comment for infinite acceleration mode). */
        500.0,                         /* Motor deceleration [step/s^2] (comment for infinite deceleration mode). */
        992.0,                         /* Motor maximum speed [step/s]. */
        0.0,                           /* Motor minimum speed [step/s]. */
        602.7,                         /* Motor full-step speed threshold [step/s]. */
        3.06,                          /* Holding kval [V]. */
        3.06,                          /* Constant speed kval [V]. */
        3.06,                          /* Acceleration starting kval [V]. */
        3.06,                          /* Deceleration starting kval [V]. */
        61.52,                         /* Intersect speed for bemf compensation curve slope changing [step/s]. */
        392.1569e-6,                   /* Start slope [s/step]. */
        643.1372e-6,                   /* Acceleration final slope [s/step]. */
        643.1372e-6,                   /* Deceleration final slope [s/step]. */
        0,                             /* Thermal compensation factor (range [0, 15]). */
        3.06 * 1000 * 1.10,            /* Ocd threshold [ma] (range [375 ma, 6000 ma]). */
        3.06 * 1000 * 1.00,            /* Stall threshold [ma] (range [31.25 ma, 4000 ma]). */
        StepperMotor::STEP_MODE_1_128, /* Step mode selection. */
        0xFF,                          /* Alarm conditions enable. */
        0x2E88                         /* Ic configuration. */
    },

    /* Second Motor. */
    {
        12.0,                           /* Motor supply voltage in V. */
        200,                           /* Min number of steps per revolution for the motor. */
        1.7,                           /* Max motor phase voltage in A. */
        3.06,                          /* Max motor phase voltage in V. */
        300.0,                         /* Motor initial speed [step/s]. */
        500.0,                         /* Motor acceleration [step/s^2] (comment for infinite acceleration mode). */
        500.0,                         /* Motor deceleration [step/s^2] (comment for infinite deceleration mode). */
        992.0,                         /* Motor maximum speed [step/s]. */
        0.0,                           /* Motor minimum speed [step/s]. */
        602.7,                         /* Motor full-step speed threshold [step/s]. */
        3.06,                          /* Holding kval [V]. */
        3.06,                          /* Constant speed kval [V]. */
        3.06,                          /* Acceleration starting kval [V]. */
        3.06,                          /* Deceleration starting kval [V]. */
        61.52,                         /* Intersect speed for bemf compensation curve slope changing [step/s]. */
        392.1569e-6,                   /* Start slope [s/step]. */
        643.1372e-6,                   /* Acceleration final slope [s/step]. */
        643.1372e-6,                   /* Deceleration final slope [s/step]. */
        0,                             /* Thermal compensation factor (range [0, 15]). */
        3.06 * 1000 * 1.10,            /* Ocd threshold [ma] (range [375 ma, 6000 ma]). */
        3.06 * 1000 * 1.00,            /* Stall threshold [ma] (range [31.25 ma, 4000 ma]). */
        StepperMotor::STEP_MODE_1_128, /* Step mode selection. */
        0xFF,                          /* Alarm conditions enable. */
        0x2E88                         /* Ic configuration. */
    }
};


/* Motor Control Expansion Board. */
XNucleoIHM02A1* x_nucleo_ihm02a1 = new XNucleoIHM02A1(&init[0], &init[1], A4, A5, D4, A2, &dev_spi);

DigitalOut actuatedLED(LED2);
const static char     DEVICE_NAME[] = "mydevice";    //   CHANGE NAME
static const uint16_t uuid16_list[] = {LEDService::LED_SERVICE_UUID};   // GATT ATTRIBUTE UUID

LEDService *ledServicePtr;

void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    (void)params;
    BLE::Instance().gap().startAdvertising(); // restart advertising
}

/**
 * This callback allows the LEDService to receive updates to the ledState Characteristic.
 *
 * @param[in] params
 *     Information about the characterisitc being updated.
 */
void onDataWrittenCallback(const GattWriteCallbackParams *params) {
    if ((params->handle == ledServicePtr->getValueHandle()) && (params->len == 1)) {
        
        if (  *(params->data)== 0x41 ) 
        {    
            actuatedLED=1      ;
            FWD();
        }
        else if (*(params->data)== 0x42)  
        { 
            actuatedLED=1      ;
            BWD();

        }
        else if (*(params->data)== 0x43)  
        { 
            actuatedLED=1      ;
            RIGHT();

        }
        else if (*(params->data)== 0x44)  
        { 
            actuatedLED=1      ;
            LEFT();
        }
        else if (*(params->data)== 0x45)  
        { 
            actuatedLED=0      ;
            SOFTSTOP();
        }
        else if (*(params->data)== 0x46)  
        { 
            actuatedLED=1      ;
        }
        else if (*(params->data)== 0x47)  
        { 
            actuatedLED=0     ;
        }  
   
    }
 
}

/** 
 * This function is called when the ble initialization process has failled 
 */ 
int onBleInitError(BLE &ble, ble_error_t error) 
{ 
    /* Initialization error handling should go here */ 
} 

/** 
 * Callback triggered when the ble initialization process has finished 
 */ 
void bleInitComplete(BLE::InitializationCompleteCallbackContext *params) 
{
    BLE&        ble   = params->ble;
    ble_error_t error = params->error;

    if (error != BLE_ERROR_NONE) {
        /* In case of error, forward the error handling to onBleInitError */
        onBleInitError(ble, error);
        return;
    }

    /* Ensure that it is the default instance of BLE */
    if(ble.getInstanceID() != BLE::DEFAULT_INSTANCE) {
        return;
    }

    ble.gap().onDisconnection(disconnectionCallback);
    ble.gattServer().onDataWritten(onDataWrittenCallback);

    bool initialValueForLEDCharacteristic = true;
    ledServicePtr = new LEDService(ble, initialValueForLEDCharacteristic);

    /* setup advertising */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.gap().setAdvertisingInterval(1000); /* 1000ms. */
    ble.gap().startAdvertising();
 
    while (true) {
        ble.waitForEvent();
    }
}

int main(void)
{       

    BLE &ble = BLE::Instance();
    
    ble.init(bleInitComplete); 
 
}
  
void FWD()
{

    /* Building a list of motor control components. */
    L6470 **motors = x_nucleo_ihm02a1->get_components();
   //otors[0]->set_home(); 

    /* Getting the current position. */
    //t position = motors[0]->get_position();

    /* Preparing each motor to perform a run at a specified speed. */
    for (int m = 0; m < L6470DAISYCHAINSIZE; m++) {
        motors[m]->prepare_run(StepperMotor::FWD, 400);
    }

    /* Performing the action on each motor at the same time. */
    x_nucleo_ihm02a1->perform_prepared_actions();
    
    /* Waiting while active. */
    motors[0]->wait_while_active();
    motors[1]->wait_while_active();
}

void BWD()
{

    /* Building a list of motor control components. */
    L6470 **motors = x_nucleo_ihm02a1->get_components();
 // motors[0]->set_home(); 

    /* Getting the current position. */
//  int position = motors[0]->get_position();

    /* Preparing each motor to perform a run at a specified speed. */
    for (int m = 0; m < L6470DAISYCHAINSIZE; m++) {
        motors[m]->prepare_run(StepperMotor::BWD, 400);
    }

    /* Performing the action on each motor at the same time. */
    x_nucleo_ihm02a1->perform_prepared_actions();
    
    /* Waiting while active. */
    motors[0]->wait_while_active();
    motors[1]->wait_while_active();
}
void LEFT()
{

    /* Building a list of motor control components. */
    L6470 **motors = x_nucleo_ihm02a1->get_components();
 // motors[0]->set_home(); 

    /* Getting the current position. */
 // int position = motors[0]->get_position();

        /* Preparing each motor to perform a run at a specified speed. */
    motors[0]->prepare_run(StepperMotor::BWD, 400);
    motors[1]->prepare_run(StepperMotor::FWD, 400);

    /* Performing the action on each motor at the same time. */
    x_nucleo_ihm02a1->perform_prepared_actions();
    
    /* Waiting while active. */
    motors[0]->wait_while_active();
    motors[1]->wait_while_active();
}
void RIGHT()
{

    /* Building a list of motor control components. */
    L6470 **motors = x_nucleo_ihm02a1->get_components();
 // motors[0]->set_home(); 

    /* Getting the current position. */
//  int position = motors[0]->get_position();

        /* Preparing each motor to perform a run at a specified speed. */
    motors[0]->prepare_run(StepperMotor::FWD, 400);
    motors[1]->prepare_run(StepperMotor::BWD, 400);

    /* Performing the action on each motor at the same time. */
    x_nucleo_ihm02a1->perform_prepared_actions();
    
    /* Waiting while active. */
    motors[0]->wait_while_active();
    motors[1]->wait_while_active();
}
void SOFTSTOP()
{
    
    /* Building a list of motor control components. */
    L6470 **motors = x_nucleo_ihm02a1->get_components();
    /* Preparing each motor to perform a hard stop. */
    for (int m = 0; m < L6470DAISYCHAINSIZE; m++) {
        motors[m]->prepare_soft_stop();
    }

    /* Performing the action on each motor at the same time. */
    x_nucleo_ihm02a1->perform_prepared_actions();

    }