// Title : mbed-os-q-32-bits-tx-rx
// Author: Jacques-Olivier Klein - IUT de CACHAN
// Date: 2018-02-10 rev. 2019-01-06 

#include "mbed.h"
#include "IHM.h"

#define THE_Q_SIZE 4

IHM ihm; 

DigitalOut L0 (PB_3) ;  // led L0
DigitalOut L1 (PA_7) ;  // led L1
DigitalOut L2 (PA_6) ;  // led L2

void tx_q();
void rx_q();

Thread thread_tx_q;
Thread thread_rx_q;

Queue<int, THE_Q_SIZE> the_queue;

int main(void) 
{   ihm.LCD_clear();
    ihm.LCD_printf("q-32b-tx-rx-%s %s",__DATE__,__TIME__);
    printf("mbed-os-q-32-bits-tx-rx-%s %s\n\r",__DATE__,__TIME__);
    printf("OS_STACK_SIZE:%d\n\r", OS_STACK_SIZE); 

    thread_tx_q.start(tx_q); 
    thread_rx_q.start(rx_q); 
    
    while(1){   
        wait(3.000);  
        L0=!L0;
        printf("*      [pid-%d]Main \n\r",osThreadGetId());
    }
}
 
void tx_q (){
    static int j=0;
    while (1){
        L1 = ! L1;
        printf("   *   Tx_q data:%d\n\r", j);
        the_queue.put((int*)j++);
        wait(1.000);      
    }
}
     
void rx_q (){
    osEvent evt;
    while (true) {
        evt = the_queue.get();
        L2 = ! L2;
        if (evt.status == osEventMessage) {
            printf("      *Rx_q data:%d\n\r", evt.value.v);
        }
    }
}
