// Title : mbed-os-periodic-task
// Author: Jacques-Olivier Klein - IUT de CACHAN
// Date: 2018-02-10

#include "mbed.h"
#include "IHM.h"

IHM ihm; 

DigitalOut L0 (PB_3) ;  // led L0
DigitalOut L1 (PA_7) ;  // led L1
DigitalOut L2 (PA_6) ;  // led L2
DigitalOut L6 (PA_0) ;  // led L6

InterruptIn BP0Interrupt(PA_9); 

void led0_fun();
void led1_fun();
void led2_fun();

EventQueue the_event_queue;

int main(void)
{   ihm.LCD_clear();
    ihm.LCD_printf("periodic-task-%s %s",__DATE__,__TIME__);
    printf("mbed-os-periodic-task-%s %s\n\r",__DATE__,__TIME__);
    printf("DEFAULT_STACK_SIZE:%d\n\r", DEFAULT_STACK_SIZE); 

    the_event_queue.call_every(100, led0_fun);
    the_event_queue.call_every(400, led1_fun);
    the_event_queue.call_every(1600, led2_fun);
    
    printf("Starting event_queue...\n\r");   
    the_event_queue.dispatch();
   
    //while(1) hereafter will never be executed    
    while(1){
        Thread::wait(500);  
        L6=!L6;
    }
}

void led0_fun()
{
   L0 = ! L0;
}

void led1_fun()
{
   L1 = ! L1;
}

void led2_fun()
{
   L2 = ! L2;
}
