// Title:  mbed-os-mutex
// Author: Jacques-Olivier Klein - IUT de CACHAN
// Date: 2018-02-10 rev. 2019-01-06

#include "mbed.h"
#include "IHM.h"

IHM ihm; 

DigitalOut L0 (PB_3) ;  // led L0
DigitalOut L1 (PA_7) ;  // led L1
DigitalOut L2 (PA_6) ;  // led L2

void bargraph_up_counter();
void bargraph_down_counter();

Mutex bargraph_mutex; 

Thread Thread_bargraph_up_counter;
Thread Thread_bargraph_down_counter;
      
 
int main(void) 
{   ihm.LCD_clear();
    ihm.LCD_printf("Mutex-%s %s",__DATE__,__TIME__);
    printf("\n\rmbed-os-mutex-%s %s\n\r",__DATE__,__TIME__);
    printf(" OS_STACK_SIZE:%d\n\r", OS_STACK_SIZE); 

    Thread_bargraph_up_counter.start(bargraph_up_counter); 
    Thread_bargraph_down_counter.start(bargraph_down_counter); 
       
    while(1){
        wait(4.000);  
        L0=!L0;
        printf("      [pid-%d]Main \n\r",osThreadGetId());
    }
}

void bargraph_up_counter(){
    static int up_counter = 1; 
    while(1){
        bargraph_mutex.lock();
         L1=1;       
        for(up_counter = 1; up_counter != 0xFF; up_counter = (up_counter<<1)|1){
            ihm.BAR_set(up_counter);
            wait(0.200); 
        }
        bargraph_mutex.unlock();
        L1=0;
    }
}

void bargraph_down_counter(){
    static int down_counter = 1; 
    while(1){
        bargraph_mutex.lock();
        L2=1;
        for(down_counter = 0x80; down_counter != 0xFF; 
                down_counter = (down_counter>>1)|0x80){
            ihm.BAR_set(down_counter);
            wait(0.200); 
        }
        bargraph_mutex.unlock();
        L2=0;
    }
}
