// Title: mbed-os-mail-5-Bytes-tx-rx
// Author: Jacques-Olivier Klein - IUT de CACHAN
// Date: 2018-02-10 rev. 2019-01-06

#include "mbed.h"
#include "IHM.h"

#define MY_MAIL_BUFFER_SIZE 5
#define MY_MAIL_NBER_OF_BUFFER 4

typedef  struct{
    char message [MY_MAIL_BUFFER_SIZE] ;
} Mail_Buffer_T; 

IHM ihm; 

DigitalOut L0 (PB_3) ;  // led L0
DigitalOut L1 (PA_7) ;  // led L1
DigitalOut L2 (PA_6) ;  // led L2

void TxMail  ();
void RxMail  ();

Mail<Mail_Buffer_T, MY_MAIL_NBER_OF_BUFFER> my_mail_box;

Thread Thread_TxMail;
Thread Thread_RxMail(osPriorityNormal,500);

Semaphore mysemaphore(0); 

int main(void) 
{   ihm.LCD_clear();
    ihm.LCD_printf("Mail-5B-tx-rx-%s %s",__DATE__,__TIME__);
    printf("\n\rmbed-os-mail-5-Bytes-tx-rx-%s %s\n\r",__DATE__,__TIME__);
    printf("DEFAULT_STACK_SIZE:%d\n\r", OS_STACK_SIZE); 

    Thread_TxMail.start(TxMail); 
    Thread_RxMail.start(RxMail); 
      
    while(1){
        wait(3.000);  
        L0=!L0;
        printf("M     [pid-%d]Main \n\r",osThreadGetId());
    }
}

void TxMail  (){
    Mail_Buffer_T * p_buffer;
    char c = '!';
    int i;
    while(1){
        p_buffer = (Mail_Buffer_T *) my_mail_box.alloc();
        for(i=0;i<MY_MAIL_BUFFER_SIZE-1;i++){
            p_buffer->message[i]=c++; 
            if (c=='}')c='!'; 
        }
        p_buffer->message[MY_MAIL_BUFFER_SIZE-1]=0;
        printf("   T  [pid-%d]TxMail:<%s>\n\r",osThreadGetId(),p_buffer->message);
        my_mail_box.put(p_buffer);
        L1 = ! L1;
        wait(2.000);
    }    
}

void RxMail (){
    Mail_Buffer_T * p_mail_buffer;
    Mail_Buffer_T local_buffer;
    while(1){
        osEvent evt = my_mail_box.get();
        L2 = ! L2;
        p_mail_buffer = (Mail_Buffer_T *)evt.value.p;      
        memcpy ( &local_buffer,p_mail_buffer, MY_MAIL_BUFFER_SIZE); 
        my_mail_box.free(p_mail_buffer);
        printf("     R[pid-%d]RxMail:<%s>\n\r",osThreadGetId(),local_buffer.message);
    }    
}
