// Title : mbed-os-isr-semaphore
// Author: Jacques-Olivier Klein - IUT de CACHAN
// Date: 2018-02-10 - rev. 2019-01-06

#include "mbed.h"
#include "IHM.h"

IHM ihm; 

DigitalOut L0 (PB_3) ;  // led L0
DigitalOut L1 (PA_7) ;  // led L1

InterruptIn BP0_Interrupt(PA_9); 

void thread_Semaphore();
void isrBP0 ();

Thread thread_waiting_for_semaphore (osPriorityNormal,OS_STACK_SIZE );;
Semaphore mysemaphore(0); 

int main(void) 
{   ihm.LCD_clear();
    ihm.LCD_printf("irq-semaphore-%s %s",__DATE__,__TIME__);
    printf("mbed-os-irq-semaphore-%s %s\n\r",__DATE__,__TIME__);
    printf("DEFAULT_STACK_SIZE:%d\n\r", OS_STACK_SIZE); 
 
    BP0_Interrupt.mode(PullUp);
    thread_waiting_for_semaphore.start(thread_Semaphore);
    BP0_Interrupt.fall(&isrBP0);
    while(1){
        L0=!L0;
        printf("*     [pid-%d]Main \n\r",osThreadGetId());
        wait(0.200);  
    }
}

void isrBP0 (){
    mysemaphore.release();
}
    
void thread_Semaphore(){
    while(1){
        mysemaphore.wait();
        L1=!L1; 
        printf("    * [pid-%d]Semaphore \n\r",osThreadGetId());
        }
}
    