// Title :mbed-os-eventflags (previously mbed-os-signals)
// Author: Jacques-Olivier Klein - IUT de CACHAN
// Date: 2018-02-11 rev. 2019-01-06

#include "mbed.h"
#include "IHM.h"

IHM ihm; 

DigitalOut L0 (PB_3) ;  // led L0
DigitalOut L1 (PA_7) ;  // led L1
DigitalOut L2 (PA_6) ;  // led L2
DigitalOut L6 (PA_0) ;  // led L6

InterruptIn BP0Interrupt(PA_9); 
InterruptIn BP1Interrupt(PA_10); 
InterruptIn BP2Interrupt(PB_0); 
InterruptIn BP3Interrupt(PB_7); 

void led_thread_signal();

void isrBP0 ();
void isrBP1 ();
void isrBP2 ();
void isrBP3 ();

Thread thread_signal;

EventFlags my_event_flags;

int main(void)
{   ihm.LCD_clear();
    ihm.LCD_printf("Events%s %s",__DATE__,__TIME__);
    printf("\n\rmbed-os-eventflags\n\r");
    printf("\n\r%s - %s\n\r",__DATE__,__TIME__);
    printf("OS_STACK_SIZE:%d\n\r", OS_STACK_SIZE); 
      BP0Interrupt.mode(PullUp);
      BP0Interrupt.fall(&isrBP0);
      BP1Interrupt.mode(PullUp);
      BP1Interrupt.fall(&isrBP1);
      BP2Interrupt.mode(PullUp);
      BP2Interrupt.fall(&isrBP2);
      BP3Interrupt.mode(PullUp);
      BP3Interrupt.fall(&isrBP3);
       
    thread_signal.start(led_thread_signal);   
 
    while(1){   
        wait(4.000);  
        L6=!L6;
        printf("M     [pid-%d]Main \n\r",osThreadGetId());
    }
}

void led_thread_signal(){   
    uint32_t flags;
    while (true) {
        flags = my_event_flags.wait_any(0x3); // wait for 1 or 2 
        ihm.BAR_set(flags);
        printf("     S [pid-%d]led6_thread_signal <%d> 1 or 2 detected \n\r",osThreadGetId(),flags);
        flags = my_event_flags.wait_all(0xC); // wait for 4 and 8 
        ihm.BAR_set(flags);
        printf("     S [pid-%d]led6_thread_signal <%d>  4 and 8 detected \n\r",osThreadGetId(),flags);
    }
}

void isrBP0 (void){
    my_event_flags.set(0x1);
}

void isrBP1 (void){
    my_event_flags.set(0x2);
}

void isrBP2 (void){
    my_event_flags.set(0x4);
}

void isrBP3 (void){
    my_event_flags.set(0x8);
}
