// Title : mbed-os-3-threads
// Author: Jacques-Olivier Klein - IUT de CACHAN
// Date: 2018-02-10

#include "mbed.h"
#include "IHM.h"

IHM ihm; 

DigitalOut L0 (PB_3) ;  // led L0
DigitalOut L1 (PA_7) ;  // led L1
DigitalOut L2 (PA_6) ;  // led L2

void led1_thread();
void led2_thread();

Thread thread1 (osPriorityNormal,2*OS_STACK_SIZE );
Thread thread2 (osPriorityNormal,2*OS_STACK_SIZE );

// main is the 1st thread
int main(void) 
{   ihm.LCD_clear();
    ihm.LCD_printf("3-threads-%s %s",__DATE__,__TIME__);
    printf("mbed-os-3-threads-%s %s\n\r",__DATE__,__TIME__);
    printf("DEFAULT_STACK_SIZE:%d\n\r", OS_STACK_SIZE); 

    thread1.start(led1_thread);   
    thread2.start(led2_thread);
 
    while(1){
        L0=!L0;
        printf("*     [pid-%d]Main \n\r",osThreadGetId());
        wait(0.0200);  
    }
}

void led1_thread(){
    while (1) {
        L1 = ! L1;
        printf("  *   [pid-%d]led1_thread \n\r",osThreadGetId());
        wait(0.500);  
  }
}

void led2_thread(){
    while (1) {
        L2 = ! L2;
        printf("     *[pid-%d]led2_thread \n\r",osThreadGetId());
        wait(2.500);  
   }
}

    