//Projet a télécharger depuis : https://developer.mbed.org/teams/NBoard/code/Automate/
#include "mbed.h"
DigitalIn BP0 (PA_9,PullUp) ;  // bouton BP0
DigitalOut L0 (PB_3) ;  // led L0
DigitalOut L1 (PA_7) ;  // led L1
DigitalOut L2 (PA_6) ;  // led L2
// prototype et variables globales et constantes
// -------------------------------------
void automate(void);
//
void main(void)
{
    // début de l'application
    // ----------------------
    while(1) {
        wait(0.2); //on poiraute 200 miliseconde
        automate();
    }
}
void automate(void)
{
    // définition d'un type énuméré permettant de manipuler l'état de l'automate
    // par son nom
    // -------------------------------------------------------------------------
    typedef enum {etat0=0, etat1=1, etat2=2} type_etat;
    type_etat etat_actuel;
    static type_etat etat_futur=etat0;
    unsigned char entree;
    // gestion des entrees
    // -------------------
    entree = !BP0;
    // gestion du diagramme de transition
    // ----------------------------------
    etat_actuel = etat_futur;
    switch(etat_actuel) {
        case etat0 :
            if (entree==1) etat_futur = etat1;
            break;
        case etat1 :
            etat_futur = etat2;
            break;
        case etat2 :
            etat_futur = etat0;
            break;
    }
    // gestion des sorties
    // -------------------
    switch(etat_actuel) {
        case etat0 :
            L0=1;
            L1=0;
            L2=0;
            break;
        case etat1 :
            L0=1;
            L1=1;
            L2=0;
            break;
        case etat2 :
            L0=1;
            L1=1;
            L2=1;
            break;
    }
}