#include "mbed.h"
#define isOn(a) a<0.3f  //Analog button pressed
InterruptIn mybutton(BUTTON1);
//servo output
PwmOut servo(D3);

//debug light
DigitalOut led(PA_5);

float pwm = 0.0f;

//user setting 
    //hertz(hz) / period time(s) of servo
    const double hertz = 50;
    const double servo_period = 1/hertz;   
//user setting end

//------------------------------------------------------------------------------------------------------------

//initialize function 
void blink_testing(double w){
    led = 0;
    for(int i = 1; i <= 2; i++){
        led = 1; wait(w);
        led = 0; wait(w);
    }
}

void m(){
    while(1){
    //button control (change: next_pulsewidth)
        servo.pulsewidth_us(servo_period * pwm);
        led = !led;
        wait(servo_period * pwm);
    }
}
void restart(){
    pwm = pwm+0.1;
    if (pwm > 1.0f)
        pwm = 0.0f;
}
int main() {
    //initialize
    mybutton.rise(&restart);
    blink_testing(0.5f);                    //blink onboard led 2 second
    servo.period(servo_period);             //set period time of servo
    m();
}