/** MyoWare Muscle Sensor control API
 *  
 *  @class   MyoWare_Muscle_Sensor
 *  @author  Jake Ashmore, Chris Turner
 *  @version 1.0b (March 7, 2017)
 *  
 *  
 *  ----------------------IMPORTANT--------------------
 *  ---------------------------------------------------
 */

#include "MyoWare.h"
#include "mbed.h"

bool digOut(float _val, float _logic) {
    if (_val > _logic) {
        return 1;    
    } else {
        return 0;
    }
}

MyoWare::MyoWare(PinName pin) :_analog(pin)
{
    _val = _analog;
}

MyoWare::MyoWare(PinName pin, float _level) :_analog(pin)
{
    _val = _analog;
    
    if ( _level > 0.0f ) {
        _logic = _level;
    } else {
        _logic = 0.0f;
    }
}

MyoWare::MyoWare(PinName pin, float _level, int _grad) :_analog(pin)
{
    _val = _analog;
    
    if ( _level > 0.0f ) {
        _logic = _level;
    } else {
        _logic = 0.0f;
    }
    
    if ( _grad > 0) {
        _sections = float((100/_grad)/100.0f);
    } else {
        _sections = 1.0f;
    }

}

float MyoWare::read() {
    return _val = _analog;
}

MyoWare::operator float() {
    return read();
}

bool MyoWare::control() {
    if ( _logic == 0.0f ) {
        return 0;
    } else {
        return digOut(_val, _logic);
    }
}

int MyoWare::magnitude() {
    int temp;
    if ( (_sections == 1.0f ) && (_val > 0.0f )) {
        temp = 1;
    } else if ( (_sections > 0.0f ) && (_val > 0.0f ) ) {
        temp = int(floor(_val/_sections));
    } else {
        temp = 0;   
    }
    return temp;
}