/** MyoWare Muscle Sensor control API
 *  
 *  @class   MyoWare_Muscle_Sensor
 *  @author  Jake Ashmore, Chris Turner
 *  @version 1.0b (March 7, 2017)
 *  
 *  
 *  ----------------------IMPORTANT--------------------
 *  ---------------------------------------------------
 */
 
#ifndef MyoWare_Mbed_H
#define MyoWare_Mbed_H

#include "mbed.h"

/** MyoWare Muscle Sensor
 *
 *  Example:
 *  @code
 *  #include "mbed.h"
 *#include "MyoWare.h"
 *
 *Serial pc(USBTX, USBRX); // tx, rx
 *
 *float logic = 0.7f; 
 *int steps = 20;
 *MyoWare ms(p15, logic, steps);
 *
 *int main() {
 *  
 *  while(1) {
 *      float sig_val = ms.read();
 *      bool onOff = ms.control();
 *      int stepNum = ms.magnitude();
 *      pc.printf("Sig Value: %f\n\r", sig_val);  
 *      pc.printf("Logic Value: %f\n\r", logic);  
 *      pc.printf("Digital Value: %d\n\r", onOff); 
 *      pc.printf("Total Steps: %d\n\r", steps);
 *      pc.printf("Step Value Value: %d\n\r", stepNum); 
 *      pc.printf("\n\r"); 
 *      wait(2);
 *  }
 *  
 *}
 *  @endcode
 */
 
class MyoWare {
    
public:
    
    MyoWare(PinName pin); //Setup myoware sensor signal pin.
    
    MyoWare(PinName pin, float _level); //Initialize with logic level.
    // Initializes the sensor API to be used as a digital out through the
    // control() function.
    
    MyoWare(PinName pin, float _level, int _grad); 
    //Initialize as digital out.
    //Includes the gradient functionality for integer steps input.
    
    float read(); //Read the input value of the myoware sensor.
    
    bool control();
    // Returns 1 if output signal value is greater than level supplied.
    // Otherwise returns 0.
    
    int magnitude();
    // Accepts a step count number, and returns the value of the step which 
    // the value currently resides.
    // EX. if the step count is 10, then gradient will return the interger of
    // the number of time the signal value is divisible by .1.
    
    operator float();
    
protected:
    AnalogIn _analog; //Input from myoware is analog in.
    float _val; //Variable for saving a single read value from the myoware.
    float _level; //Variable for setting the input logic level control.
    float _logic; //Single read value of the _level control.
    int _grad; //Input variable for the number of gradient steps.
    float _sections; //Value for containing the current value of each section.

};

#endif