#include "mbed.h"

PwmOut Motor_A(PB_3);
PwmOut Motor_B(PA_7);
DigitalOut Direction_A(PA_6);
DigitalOut Direction_B(PA_5);
DigitalIn Taster1(PB_4);
DigitalOut Led1(PB_10);
Timer timer;

float drehzeit=0.17;

int fahren(int speed, int direction, int time){
    Motor_A.pulsewidth_us(speed);
    Motor_B.pulsewidth_us(speed);
    Direction_A=direction;
    Direction_B=direction;
    wait(time);
    return 1;
}

float drehkalibrierung(){
    fahren(0,0,0);
    while(Taster1){}//Warten,bis Taster nicht gedrueckt
    while (not Taster1){}//User starts kalibration (Press Taster1)
    while(Taster1){}
    wait(0.5);
    Led1=1;
    float start=timer.read();
    //pc.printf("Drehkalibrierung...");
    
    Direction_A=0;
    Direction_B=1;
    Motor_A.pulsewidth_us(8000);
    Motor_B.pulsewidth_us(8000);
    wait(0.5);
    
    while (not Taster1){}//Turned 360 degrees
    float dauer=timer.read()-start;
    fahren(0,0,0);
    Led1=0;
    while (Taster1){}
    return dauer/360;
}

int drehen(int winkel){
    int dir_a=Direction_A;
    int dir_b=Direction_B;
    Direction_A=0;
    if (winkel<0){
        winkel=0-winkel;
        Direction_A=1;
    }
    Direction_B=!Direction_A;
    Motor_A.pulsewidth_us(8000);
    Motor_B.pulsewidth_us(8000);
    wait(winkel*drehzeit);
    Direction_A=dir_a;//Zuruecksetzen
    Direction_B=dir_b;
    //pc.printf("Um %d Grad gedreht",winkel);
    fahren(0,0,0);
    return 1;
}

int fahre_eine_acht(){
    for (int i=0;i<3;i++){
        fahren(6000,0,1);
        drehen(90);
    }
    fahren(6000,0,1);
    for (int j=0;j<3;j++){
        fahren(6000,0,1);
        drehen(-90);
    }
    fahren(6000,0,1);
    fahren(0,0,0);
    return 1;
}
int quadrat(int richtung){
    for (int i=0;i<4;i++){
        fahren(6000,0,2);
        drehen(90*richtung);
    }
    fahren(0,0,0);
    return 1;
}    
int main() {
    timer.reset();
    timer.start();
    Motor_A.period_ms(10);
    Motor_A.pulsewidth_us(1);
    Motor_B.period_ms(10);
    Motor_B.pulsewidth_us(1);
    
    
    Serial pc (USBTX,USBRX);
    pc.baud(115200);
    fahren(0,0,0);
    while(true) {
        /*pc.printf("Ich fahre ein Quadrat %3.1f \r\n",timer.read());
        quadrat(1);
        fahren(0,0,0);
        pc.printf("Gefahren %3.1f \r\n",timer.read());
        */
        while (not Taster1){}
        if (Taster1){
            pc.printf("Drehkalibrierung...");
            //Led1=1;
            wait(1);
            drehzeit=drehkalibrierung();
            pc.printf("Drehzeit kalibriert. %2.7f fuer 1 Grad\r\n",drehzeit);
            
            wait(0.5);
            pc.printf("Zurueckdrehen\r\n");
            drehen(-360);
       }
    }
}
