// Mede dois sinais
#include "mbed.h"
#include "math.h" // Descomente esta linha caso queira usar funções como sin(x)

#include "signal.h"


Ticker flipper;
AnalogIn ain0(PTB0);
AnalogIn ain1(PTB1);
DigitalOut myled(LED1);
int aux2 = 0; // Variavel auxiliar, para indicar quando realizar uma amostragem

int i =0;
float soma_canal0 = 0, soma_canal1, soma_quadrados_canal0, soma_quadrados_canal1 =0;

float media_dc_canal0, media_dc_canal1, media_ac_canal0, media_ac_canal1;

float tensao_maxima = 3.3;

void flip() {
 aux2 = !aux2;
}
// Classe Signal ------------------------
class Signal {
    public:
    float signal_array[1000];
    char signal_type;
    void generate(char signal_tyoe, float amplitude, float ordinary_frequency); 
    // q for quadrate, s for senoidal, t for triangular
    void erase();
    float soma();
    float eficaz();
    float amplitude();
    float period(float dc_value);
    };
   
void Signal::generate(char signal_tyoe, float amplitude, float ordinary_frequency){
    int count;
    float angular_frequency = 2*3.1415*ordinary_frequency;
        
    for(count = 0; count <1000; count++){
        if (signal_tyoe == 's') {
            angular_frequency = count;
            signal_array[count] = amplitude*cos(angular_frequency);
                
            }  
        }    
    }
    
void Signal::erase(){
    int count;
        
    for(count = 0; count <=1000; count++){
            signal_array[count] = 0;
        }  
    }    
    
float Signal::soma(){
    int count;
    float soma = 0;
        
    for(count = 0; count <1000; count++){
            soma += signal_array[count];
        }  
    return soma;
    }   
    
float Signal::eficaz(){
    int count;
    float soma_quadrados = 0;
        
    for(count = 0; count <1000; count++){
            soma_quadrados += signal_array[count]*signal_array[count];
        }  

    return sqrt(soma_quadrados);
    } 
    
float Signal::amplitude(){
    int count;
    float amplitude = signal_array[0];
    
    for(count = 1; count <1000; count++){
        if (amplitude < signal_array[count])  
            amplitude = signal_array[count];
        }  

    return amplitude;
    } 

float Signal::period(float dc_value){
    int count;
    int position, pre_position;
    int crossings = 0;
    float period = 0;
    if (signal_array[0] > dc_value) {
            pre_position = 1; //acima da linha dc
        }
    else{
            pre_position = 0; //abaixo da linha dc      
        }
   
    for(count = 1; count <1000; count++){
        if (signal_array[count] > dc_value) {
             position = 1; //acima da linha dc
            }
        else{
             position = 0; //abaixo da linha dc      
            }   
               
        if (position != pre_position){
            period += (count - period);
            crossings += 1;
            pre_position = position;
        }  
    }
    return (period/crossings)*2;
    } 
// Classe Signal - END   

// ---------------MAIN------------------------------

int main()
{ 
    // valor mínimo de ts: ~0.0001 (10 kHz)
    int contador = 0, tamanho=1000; 
    // Tamanho dos vetores de amostras.
    float ts = 0.0001, sinal0[tamanho], sinal1[tamanho];

    myled = 0; // Acende led
    flipper.attach(&flip, ts); // chama a funcao flip apos ts segundos
 
    while(contador<tamanho) {
        if(aux2 == 1){
            sinal0[contador] = ain0; // lê sinais analógicos de dois canais
            sinal1[contador] = ain1;
            aux2 = 0;
            contador++;
        }
    }

    flipper.detach(); /* para o ticker */
    myled = 1; 
    // Apaga led quando termina
    
    // Coloque aqui o seu programa para tratamento dos dados.
 
    printf("\n MULTIMETRO DIGITAL versao 1.06 \n\r");
    //gera sinais artificiais para teste
    // deixe comentado se quiser utilizar a amostragem normal

    Signal canal0;
    Signal canal1;

    canal0.generate('s', 1, 1000);
    // gera sinal s - senoidal, amplitude = 1 e frequencia = 1kHz
    
    canal1.generate('s', 1, 2000);
    // gera sinal s - senoidal, amplitude = 1 e frequencia = 2kHz
    

    printf("\n Terminada a aquisicao \n \r");
         
//         printf("%.2f  ",sinal0[i]);
//         soma_canal0 += sinal0[i];
//         soma_quadrados_canal0 += sinal0[i]*sinal0[i];

    //printf("Soma Canal 0 %.2f ",soma_canal0);   
    //printf("Soma dos quadrados canal 0 %.2f ",soma_quadrados_canal0);     
    
    media_dc_canal0 = canal0.soma()*ts/0.1;
    media_dc_canal1 = canal1.soma()*ts/0.1;
    media_ac_canal0 = canal0.eficaz()*sqrt(ts/0.1);
    media_ac_canal1 = canal1.eficaz()*sqrt(ts/0.1);    
        
        
    printf("Tensao DC Canal 0: %4.2f \n\r",tensao_maxima*media_dc_canal0);   
    printf("Tensao eficaz AC canal 0: %4.2f \n\r",tensao_maxima*media_ac_canal0);          
    printf("Tensao DC Canal 1: %4.2f \n\r",tensao_maxima*media_dc_canal1);   
    printf("Tensao eficaz AC canal 1: %4.2f \n\r",tensao_maxima*media_ac_canal1);          

// Calculo do delta t sendo Canal 0 como referencia





} 
//fim