-----------------------------------------------------------------------------------------
Introduction
-----------------------------------------------------------------------------------------

The xdot bootloader is used to allow ymodem flashing of the application into the 
STM32L151CC flash memory space. As of this writing, the bootloader takes up 32 kB. The
application is flashed in after the bootloader space.

-----------------------------------------------------------------------------------------
Bootloader CLI (Command Line Interface)
-----------------------------------------------------------------------------------------

The bootloader is equipped with a simple command line interface.  It can be accessed
with the following steps:
    * Connect your favorite terminal program to either virtual serial port provided
      by the USB connection between the device and your PC (COMXX on Windows,
      /dev/ttyACMXX or /dev/ttyXRUSBX on Linux)
    * Set your terminal program to run at 115200 baud
    * Reset the device and enter 'x' within 250ms then 'd' within 500ms and finally 'x'
      within 500ms
    * You should see a prompt appear that looks like "bootloader:>"
    * Your bootloader is now in CLI mode and ready to execute commands (see below)

There are two commands the bootloader supports in CLI mode:

    boot        
                Start the application currently saved in the microcontroller's flash.

    upgrade 
                Ymodem new firmware over serial to internal STM32L151CC flash memory
		starting at the memory location following the bootloader area.

-----------------------------------------------------------------------------------------
Firmware Upgrade Procedure
-----------------------------------------------------------------------------------------

When the device is powered on, the bootloader executes before starting the application
currently saved in the microcontroller's flash.  If the bootloader does not see an 'x'
in the first 250ms, it will jump to the application. After receiving 'x', it will jump
to the application if it does not receive a 'd' in 500ms. Lastly it will jump to the 
application if it does not receive a 't' in 500ms. If it does receive 'xdt', it will
output the menu of commands.

If menu option 'upgrade' is entered, the bootloader will erase the application area of
flash and setup for ymodem receive. As the attached device sends via ymodem, each block
is written to the application area. Upon completion, the bootloader will reset the 
processor.

If flashing the new firmware fails, the previous application is lost as there is no 
backup but the bootloader will remain intact and can process additional ymodem file
transfer attempts.

-----------------------------------------------------------------------------------------
Bootloader Integration
-----------------------------------------------------------------------------------------
In order to build an application with this bootloader, your application's mbed_app.json
configuration file needs to be updated to point to the bootloader binary.  An example is
provided in the mbed_app_BOOTLOADER_CFG.json file packaged in this repo.
