/*************************************
 * This simple example program blinks
 * a LED and prints a message out the
 * USB debug port.
 ************************************/

#include "mbed.h"

// Uncomment this line if using a full sized UDK2.0 instead of a Micro UDK
// #define UDK2 1

#ifdef UDK2
DigitalOut led(LED1);
#else
DigitalOut led(XBEE_RSSI);
#endif

Ticker tick;

// callback function to change LED state
void blink() {
    led = !led;
}

int main() {
    // configure the Ticker to blink the LED on 500ms interval
    tick.attach(&blink, 0.5);
    
    // print the message on 2s interval
    while (true) {
        printf("Hello world!\r\n");
        wait(2);
    }
}