/** mDot PwmOut Example Program
 *
 * This program demonstrates how to do pulse width modulation on
 * and output pin using the MultiTech mDot and MultiTech UDK2
 * hardware. The only additional hardware required is a LED.
 *
 * This program PWMs the XBEE_DO8 (UDK2 D12) pin. It should go from 0% to 100% duty
 * cycle in 5% increments and then from 100% to 0% in 5% increments.
 */
 
#include "mbed.h"
 
int main() {
    PwmOut out(XBEE_DO8);
    
    while (true) {
        for (float f = 0.0f; f < 1.0f; f += 0.05f) {
            out = f;
            wait_ms(50);
        }
        for (float f = 1.0f; f > 0.0f; f -= 0.05f) {
            out = f;
            wait_ms(50);
        }
    }
}