/** mDot InterruptIn Example Program
 *
 * This program demonstrates how to handle external interrupts using the
 * MultiTech mDot and MultiTech UDK2 hardware. The only
 * additional hardware required is a jumper wire.
 *
 * Pins are active low, so 0V = 0 and 5V/3.3V = 1.
 *
 * This program configures interrupt handlers for rising and falling edges
 * on pin XBEE_AD3 (UDK2 pin D10).
 */
 
#include "mbed.h"

bool rise_flag = false;
bool fall_flag = false;

void rise_handler(void) {
    rise_flag = true;
}

void fall_handler(void) {
    fall_flag = true;
}
 
int main() {
    InterruptIn in(XBEE_AD3);
    in.rise(&rise_handler);
    in.fall(&fall_handler);
    
    while (true) {
        if (rise_flag) {
            printf("rising edge\r\n");
            rise_flag = false;
        }
        if (fall_flag) {
            printf("falling edge\r\n");
            fall_flag = false;
        }
        
        wait_ms(100);
    }
}