/** mDot DigitalOut and BusOut Example Program
 *
 * This program demonstrates how to write digital outputs using the
 * MultiTech mDot and MultiTech UDK2 hardware. The only
 * additional hardware required is LEDs. Connect the LEDs between the
 * bus pins and ground.
 *
 * Pins are active low, so 0V = 0 and 5V/3.3V = 1.
 *
 * This program blinks the PA_0 (UDK2 D3) LED using a DigitalOut pin and writes
 * to pins PA_4, PA_6, and PA_5 (UDK2 pins D10, D12, and D13) as a 3 pin bus.
 */
 
#include "mbed.h"
 
int main() {
    // write digital pins PA_4, PA_6, and PA_5 as a 3 pin bus
    // the first pin is the LSB of the bus, the last is the MSB
    BusOut bus(PA_4, PA_6, PA_5);
    // pin PA_0 is connected to the D3 LED
    DigitalOut led(PA_0);
    
    int count = 0;
    
    while (true) {
        printf("writing %d to bus\r\n", count);
        bus = count++;
        count %= 8;
        
        led = !led;
        
        wait_ms(500);
    }
}