/** mDot DigitalIn and BusIn Example Program
 *
 * This program demonstrates how to read digital inputs using the
 * MultiTech mDot and MultiTech UDK2 hardware. The only
 * additional hardware required is jumper wires.
 *
 * Pins are active low, so 0V = 0 and 5V/3.3V = 1.
 *
 * This program prints the new value of the BusIn each time it changes
 * and the new value of the DigitalIn each time it changes.
 */
 
#include "mbed.h"
 
int main() {
    // read digital pins PA_4 and PA_6 (UDK2 pins D10 and D12) as a 2 pin bus
    // the first pin is the LSB of the bus, the last is the MSB
    BusIn bus(PA_4, PA_6);
    // read digital pin PA_5 (UDK2 pin D13)
    DigitalIn din(PA_5);
    
    int old_bus = -1;
    int old_din = -1;
    
    while (true) {
        if (bus != old_bus) {
            old_bus = bus;
            printf("bus = %d\r\n", old_bus);
        }
        if (din != old_din) {
            old_din = din;
            printf("din = %d\r\n", old_din);
        }
        
        wait_ms(100);
    }
}