/** mDot AnalogIn Example Program
 *
 * This program demonstrates how to read an anglog pin using the
 * MultiTech mDot and MultiTech UDK2 hardware. The only
 * additional hardware required is an analog voltage source like
 * a potentiometer.
 *
 *
 * This program reads the analog input connected to pin PB_1 (UDK2
 * pin A0) and prints the result.
 */
 
#include "mbed.h"
 
int main() {
    AnalogIn in(PB_1);
    
    while (true) {
        printf("analog value: 0x%04X\r\n", in.read_u16());
        wait_ms(500);
    }
}