#include "mbed.h"
#include "mDot.h"
#include "CommandTerminal.h"
#include "ATSerial.h"
#include "ATSerialFlowControl.h"
#include "ChannelPlans.h"

#define SERIAL_BUFFER_SIZE 512

mts::ATSerial debug(USBTX, USBRX);

#ifndef UNIT_TEST

#ifndef CHANNEL_PLAN
#define CHANNEL_PLAN CP_KR920
#endif

int main()
{
    debug.baud(115200);
    
    // get a mDot handle
    mDot* dot = mDot::getInstance();

#if CHANNEL_PLAN == CP_AS923
    lora::ChannelPlan* plan = new lora::CustomChannelPlan_AS923(*dot->getRadio(), *dot->getSettings());
#elif CHANNEL_PLAN == CP_US915
    lora::ChannelPlan* plan = new lora::CustomChannelPlan_US915(*dot->getRadio(), *dot->getSettings());
#elif CHANNEL_PLAN == CP_AU915
    lora::ChannelPlan* plan = new lora::CustomChannelPlan_AU915(*dot->getRadio(), *dot->getSettings());
#elif CHANNEL_PLAN == CP_EU868
    lora::ChannelPlan* plan = new lora::CustomChannelPlan_EU868(*dot->getRadio(), *dot->getSettings());
#elif CHANNEL_PLAN == CP_KR920
    lora::ChannelPlan* plan = new lora::CustomChannelPlan_KR920(*dot->getRadio(), *dot->getSettings());
#elif CHANNEL_PLAN == CP_IN865
    lora::ChannelPlan* plan = new lora::CustomChannelPlan_IN865(*dot->getRadio(), *dot->getSettings());
#endif


    dot->setChannelPlan(plan);

    // Seed the RNG
    srand(dot->getRadioRandom());

    mts::ATSerial* serial;

    if (dot->getFlowControl())
#if defined(TARGET_MTS_MDOT_F411RE)
        serial = new mts::ATSerialFlowControl(XBEE_DOUT, XBEE_DIN, XBEE_RTS, XBEE_CTS, SERIAL_BUFFER_SIZE, SERIAL_BUFFER_SIZE);
#else
        serial = new mts::ATSerialFlowControl(UART1_TX, UART1_RX, UART1_RTS, UART1_CTS, SERIAL_BUFFER_SIZE, SERIAL_BUFFER_SIZE);
#endif
    else
#if defined(TARGET_MTS_MDOT_F411RE)
        serial = new mts::ATSerial(XBEE_DOUT, XBEE_DIN, SERIAL_BUFFER_SIZE, SERIAL_BUFFER_SIZE);
#else
        serial = new mts::ATSerial(UART1_TX, UART1_RX, SERIAL_BUFFER_SIZE, SERIAL_BUFFER_SIZE);
#endif

    debug.baud(dot->getDebugBaud());
    serial->baud(dot->getBaud());

    CommandTerminal term(*serial);
    CommandTerminal::_dot = dot;

    term.init();

    term.start();
}

#endif // UNIT_TEST

