#ifndef _FRAGMENTATION_MATH_H
#define _FRAGMENTATION_MATH_H
#ifdef FOTA

#include "mbed.h"
#include "mDot.h"
#include "WriteFile.h"

#define FRAG_SESSION_ONGOING    0xffffffff

typedef struct {
    uint16_t NbOfFrag;   
    uint16_t Redundancy;
    uint8_t  DataSize; 
} FragmentationSessionParams_t;

class FragmentationMath
{
  public:
    FragmentationMath(mDot* dot, uint16_t frame_count, uint8_t frame_size, uint16_t redundancy_max,  WriteFile* fh);
    ~FragmentationMath();
    bool initialize();
    int get_lost_frame_count();
    void reset(uint16_t fcount);
    void set_frame_found(uint16_t frameCounter);
    bool process_redundant_frame(uint16_t frameCounter, uint8_t *rowData, FragmentationSessionParams_t sFotaParameter);

  private:
    int FragmentationPrbs23(int x);
    bool IsPowerOfTwo(unsigned int x);
    uint16_t FindMissingFrameIndex(uint16_t x);
    void GetRowInFlash(int l, uint8_t *rowData);
    int FindFirstOne(uint8_t *boolData, int size);
    bool VectorIsNull(uint8_t *boolData, int size);
    void StoreRowInFlash(uint8_t *rowData, int index);
    void FindMissingReceiveFrame(uint16_t frameCounter);
    void XorLineData(uint8_t *dataL1, uint8_t *dataL2, int size);
    void XorLineBool(uint8_t *dataL1, uint8_t *dataL2, int size);
    void FragmentationGetParityMatrixRow(int N, int M, uint8_t *matrixRow);
    void PushLineToBinaryMatrix(uint8_t *boolVector, int rownumber, int numberOfBit);
    void ExtractLineFromBinaryMatrix(uint8_t *boolVector, int rownumber, int numberOfBit);

    int m2l;
    uint8_t _frame_size; 
    uint16_t _frame_count;
    uint16_t _redundancy_max;
    uint16_t numFramesMissing;
    uint16_t lastReceiveFrameCnt;

    uint8_t *s;
    uint8_t *matrixM2B;
    uint8_t *matrixRow;
    uint8_t *matrixDataTemp;
    uint8_t *dataTempVector;
    uint8_t *dataTempVector2;
    uint8_t *missingFrameIndex;

    mDot* _dot;
    WriteFile* _fh;
};
#endif
#endif // _FRAGMENTATION_MATH_H
