/** Any non-root certificates will have no effect on the SSL client, but will
 * use up extra space for their allocation into the certificate list.
 * Methods for obtaining the Root CA certificate(s) for a website:
 * 1. Open a browser to the target website using HTTPS. 
 *      (These instructions are for Chrome, but should be similar for other browsers)
 *      Click on the lock icon at the beginning of the url, select the "connection" tab,
 *      and click the "certificate information" hyperlink. The browser will open a new window
 *      labeled "Certificate". Switch to the "Certification Path" tab, click the certificate 
 *      closest to the top of the window, then click "View Certificate". This will open a new
 *      window labeled "Certificate" again. This time, click on the "Details" tab, then click 
 *      "Copy to File". This will open a "Certificate Export Wizard". Click next, and choose the 
 *      "Base-64 encoded X.509 (.CER)" option, then click next. Choose the name and location where
 *      you want to save the PEM formatted certificate, then click next, then finish. Open the file
 *      that was created and copy-paste the certificate into this certs.h file. Format the certificate
 *      data so that each line begins with " and is appended with \r\n"
 *
 * 2. Go to https://www.bluessl.com/en/ssltest and enter the website for which you wish to get the root CA
 *      certificates. Click the [Click here to download the public part of this certificate] button located
 *      underneath the certificates that label themselves as Root, or Root CA. The root CA certificate should
 *      self-signed, otherwise it is not the root CA certificate. Take the downloaded file, copy the data
 *      into this certs.h file, and format the data so that each line begins with " and is appended with \r\n"
 *      
 * 3. Using openssl on linux: (Make sure you have openssl installed.) Run the command: openssl s_client
 *      -showcerts -connect <host>:<port> -CApath /etc/ssl/certs
 *      Where <host> is the host name (www.google.com for example), and port is the port on which the connection
 *      will be made (usually 443). When the connection is made with the remote server, the last certificate(s)
 *      listed will be the Root CA certificate(s). Merely copy-paste those certificates into this certs.h file
 *      and format them with each line beginning with " and ending with \r\n"
 *      
 */


//Root Certificates
char CERTIFICATES[1547] = 
    
    //Root certificate Authority for Httpbin.org
    "-----BEGIN CERTIFICATE-----\r\n"
    "MIIENjCCAx6gAwIBAgIBATANBgkqhkiG9w0BAQUFADBvMQswCQYDVQQGEwJTRTEU\r\n"
    "MBIGA1UEChMLQWRkVHJ1c3QgQUIxJjAkBgNVBAsTHUFkZFRydXN0IEV4dGVybmFs\r\n"
    "IFRUUCBOZXR3b3JrMSIwIAYDVQQDExlBZGRUcnVzdCBFeHRlcm5hbCBDQSBSb290\r\n"
    "MB4XDTAwMDUzMDEwNDgzOFoXDTIwMDUzMDEwNDgzOFowbzELMAkGA1UEBhMCU0Ux\r\n"
    "FDASBgNVBAoTC0FkZFRydXN0IEFCMSYwJAYDVQQLEx1BZGRUcnVzdCBFeHRlcm5h\r\n"
    "bCBUVFAgTmV0d29yazEiMCAGA1UEAxMZQWRkVHJ1c3QgRXh0ZXJuYWwgQ0EgUm9v\r\n"
    "dDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALf3GjPm8gAELTngTlvt\r\n"
    "H7xsD821+iO2zt6bETOXpClMfZOfvUq8k+0DGuOPz+VtUFrWlymUWoCwSXrbLpX9\r\n"
    "uMq/NzgtHj6RQa1wVsfwTz/oMp50ysiQVOnGXw94nZpAPA6sYapeFI+eh6FqUNzX\r\n"
    "mk6vBbOmcZSccbNQYArHE504B4YCqOmoaSYYkKtMsE8jqzpPhNjfzp/haW+710LX\r\n"
    "a0Tkx63ubUFfclpxCDezeWWkWaCUN/cALw3CknLa0Dhy2xSoRcRdKn23tNbE7qzN\r\n"
    "E0S3ySvdQwAl+mG5aWpYIxG3pzOPVnVZ9c0p10a3CitlttNCbxWyuHv77+ldU9U0\r\n"
    "WicCAwEAAaOB3DCB2TAdBgNVHQ4EFgQUrb2YejS0Jvf6xCZU7wO94CTLVBowCwYD\r\n"
    "VR0PBAQDAgEGMA8GA1UdEwEB/wQFMAMBAf8wgZkGA1UdIwSBkTCBjoAUrb2YejS0\r\n"
    "Jvf6xCZU7wO94CTLVBqhc6RxMG8xCzAJBgNVBAYTAlNFMRQwEgYDVQQKEwtBZGRU\r\n"
    "cnVzdCBBQjEmMCQGA1UECxMdQWRkVHJ1c3QgRXh0ZXJuYWwgVFRQIE5ldHdvcmsx\r\n"
    "IjAgBgNVBAMTGUFkZFRydXN0IEV4dGVybmFsIENBIFJvb3SCAQEwDQYJKoZIhvcN\r\n"
    "AQEFBQADggEBALCb4IUlwtYj4g+WBpKdQZic2YR5gdkeWxQHIzZlj7DYd7usQWxH\r\n"
    "YINRsPkyPef89iYTx4AWpb9a/IfPeHmJIZriTAcKhjW88t5RxNKWt9x+Tu5w/Rw5\r\n"
    "6wwCURQtjr0W4MHfRnXnJK3s9EK0hZNwEGe6nQY1ShjTK3rMUUKhemPR5ruhxSvC\r\n"
    "Nr4TDea9Y355e6cJDUCrat2PisP29owaQgVR1EX1n6diIWgVIEM8med8vSTYqZEX\r\n"
    "c4g/VhsxOBi0cQ+azcgOno4uG+GMmIPLHzHxREzGBHNJdmAPx/i9F4BrLunMTA5a\r\n"
    "mnkPIAou1Z5jJh5VkpTYghdae9C8x49OhgQ=\r\n"
    "-----END CERTIFICATE-----\r\n"
    ;