#include "mbed.h"
#include "mtsas.h"

int main(){
    //Modify to match your apn if you are using an HSPA radio with a SIM card
    const char APN[] = "";
    
    //Sets the log level to INFO, higher log levels produce more log output.
    //Possible levels: NONE, FATAL, ERROR, WARNING, INFO, DEBUG, TRACE
    MTSLog::setLogLevel(MTSLog::INFO_LEVEL);
    
    /** STMicro Nucelo F401RE
    * The supported jumper configurations of the MTSAS do not line up with
    * the pin mapping of the Nucleo F401RE. Therefore, the MTSAS serial TX
    * pin (JP8 Pin 2) must be manually jumped to Serial1 RX (Shield pin D2)
    * and the MTSAS serial RX pin (JP9 Pin 2) pin must be manually jumped to
    * Serial1 TX (Shield pin D8).
    * Uncomment the following line to use the STMicro Nuceleo F401RE
    */
    MTSSerialFlowControl* io = new MTSSerialFlowControl(D8, D2, D3, D6);
    
    /** Dragonfly
    * To configure the serial pins for the Dragonfly board, use:
    * RADIO_TX = pin PC_7, RADIO_RX = pin PC_6
    * RADIO_RTS = pin PB_10,RADIO_CTS = pin PB_12
    * Uncomment the following line to use the Dragonfly board
    */
    //MTSSerialFlowControl* io = new MTSSerialFlowControl(RADIO_TX, RADIO_RX, RADIO_RTS, RADIO_CTS);
    
    /** Freescale KL46Z
    * To configure the serial pins for the Freescale KL46Z board, use MTSAS jumper 
    * configuration B. Uncomment the following line to use the Freescale KL46Z board
    */
    //MTSSerialFlowControl* io = new MTSSerialFlowControl(D2, D9, D3, D6);
    
    /** Freescale K64F
    * To configure the serial pins for the Freescale K64F board, use MTSAS jumper
    * configuration A. Uncomment the following line to use the Freescale K64F board
    */
    //MTSSerialFlowControl* io = new MTSSerialFlowControl(D1, D0, D3, D6);
    
    //Sets the baud rate for communicating with the radio
    io->baud(115200);
    
    //Create radio object
    Cellular* radio = CellularFactory::create(io);
    
    if (! radio) {
        logFatal("Failed to initialize radio");
        return 1;
    }
    Transport::setTransport(radio);
    
    //Set radio APN
    for (int i = 0; i < 10; i++) {
        if (i >= 10) {
            logError("Failed to set APN to %s", APN);
        }
        if (radio->setApn(APN) == MTS_SUCCESS) {
            logInfo("Successfully set APN to %s", APN);
            break;
        } else {
            wait(1);
        }
    }
    
    //Establish PPP link
    for (int i = 0; i < 10; i++) {
        if (i >= 10) {
            logError("Failed to establish PPP link");
        }
        if (radio->connect() == true) {
            logInfo("Successfully established PPP link");
            break;
        } else {
            wait(1);
        }
    }
    
    //Ping google.com
    for (int i = 0; i < 10; i++) {
        if (i >= 10) {
            logError("Failed to ping www.google.com");
        }
        if (radio->ping("www.google.com") == true) {
            logInfo("Successfully pinged www.google.com");
            break;
        } else {
            wait(1);
        }
    }
    
    //Disconnect ppp link
    radio->disconnect();
    
    logInfo("End of example code");
    return 0;
} 