#include "mbed.h"
#include "MTSSerial.h"
#include "MTSLog.h"

using namespace mts;

MTSSerial::MTSSerial(PinName TXD, PinName RXD, int txBufferSize, int rxBufferSize)
    : MTSBufferedIO(txBufferSize, rxBufferSize)
    , _serial(new RawSerial(TXD,RXD)),
    _baudrate(9600),
    _bits(8),
    _parity(mbed::SerialBase::None),
    _stop_bits(1)
{
    _serial->attach(callback(this, &MTSSerial::handleRead), Serial::RxIrq);
}

MTSSerial::~MTSSerial()
{
}



void MTSSerial::baud(int baudrate)
{
    _baudrate = baudrate;
    _serial->baud(_baudrate);
}

void MTSSerial::format(int bits, SerialBase::Parity parity, int stop_bits)
{
    _bits = bits;
    _parity = parity;
    _stop_bits = stop_bits;
    _serial->format(_bits, _parity, _stop_bits);
}

void MTSSerial::handleRead()
{
    rxBuffer.write(_serial->getc());
}

void MTSSerial::handleWrite()
{
    while(txBuffer.size() != 0) {
        if (_serial->writeable()) {
            char byte;
            if(txBuffer.read(byte) == 1) {
                _serial->attach(NULL, Serial::RxIrq);
                _serial->putc(byte);
                _serial->attach(callback(this, &MTSSerial::handleRead), Serial::RxIrq);
            }
        } else {
            return;
        }
    }
}

void mts::MTSSerial::reattach(PinName TXD, PinName RXD) {
    delete _serial;
    _serial = new RawSerial(TXD, RXD);
    _serial->attach(callback(this, &MTSSerial::handleRead), Serial::RxIrq);
    _serial->baud(_baudrate);
    _serial->format(_bits, _parity, _stop_bits);
    rxBuffer.clear();
    txBuffer.clear();
}

void mts::MTSSerial::sendBreak() {
    _serial->send_break();
}
