/* Copyright (c) <2018> <MultiTech Systems>, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "CmdJoinDelay.h"

CmdJoinDelay::CmdJoinDelay(mDot* dot, mts::MTSSerial& serial)
    : Command(dot, "Join Delay", "AT+JD", "Number of seconds before receive windows are opened for join (1 - 15)")
    , _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(1-15)";
    _queryable = true;
}

uint32_t CmdJoinDelay::action(std::vector<std::string> args)
{
    if (args.size() == 1) {
        _serial.writef("%u\r\n", _dot->getJoinDelay());
    } else if (args.size() == 2) {
        uint32_t joinDelay;
        sscanf(args[1].c_str(), "%lu", &joinDelay);

        if (_dot->setJoinDelay(joinDelay) != mDot::MDOT_OK) {
            setErrorMessage(_dot->getLastError());
            return 1;
        }
    }

    return 0;
}

bool CmdJoinDelay::verify(std::vector<std::string> args)
{
    if (args.size() == 1)
        return true;

    if (args.size() == 2) {
        int joinDelay;
        if (sscanf(args[1].c_str(), "%d", &joinDelay) == 1) {
            if (joinDelay > 15 || joinDelay < 1) {
                setErrorMessage("Invalid join delay, expects (1-15)");
                return false;
            }
            return true;
        }
    }

    setErrorMessage("Invalid arguments");
    return false;
}
